/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.BurstExecutor;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MultiBurst {
    public static MultiBurst burst;
    private final ExecutorService service;
    private int tid;

    public MultiBurst(int n) {
        this.service = Executors.newFixedThreadPool(n, runnable -> {
            ++this.tid;
            Thread thread2 = new Thread(runnable);
            thread2.setName("Adapt Workgroup " + this.tid);
            thread2.setPriority(10);
            thread2.setUncaughtExceptionHandler((thread, throwable) -> {
                Adapt.info("Exception encountered in " + thread.getName());
                throwable.printStackTrace();
            });
            return thread2;
        });
    }

    public void burst(Runnable ... runnableArray) {
        this.burst(runnableArray.length).queue(runnableArray).complete();
    }

    public void sync(Runnable ... runnableArray) {
        for (Runnable runnable : runnableArray) {
            runnable.run();
        }
    }

    public BurstExecutor burst(int n) {
        return new BurstExecutor(this.service, n);
    }

    public BurstExecutor burst() {
        return this.burst(16);
    }

    public void lazy(Runnable runnable) {
        this.service.execute(runnable);
    }

    public ExecutorService getService() {
        return this.service;
    }

    static {
        IBootstrap.dasBoot();
        burst = new MultiBurst(Runtime.getRuntime().availableProcessors());
    }
}

