/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.ParticleType;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.material.MaterialData;

interface ParticleSender {
    public void spawnParticle(Object var1, ParticleType var2, double var3, double var5, double var7, int var9, double var10, double var12, double var14, double var16, Object var18);

    public Object getParticle(ParticleType var1);

    public boolean isValidData(Object var1, Object var2);

    default public double color(double color) {
        return color / 255.0;
    }

    public static class ParticleSender1_13
    extends ParticleSenderImpl {
        @Override
        public void spawnParticle(Object object, ParticleType particleType, double d, double d2, double d3, int n, double d4, double d5, double d6, double d7, Object object2) {
            Particle particle = Particle.valueOf((String)particleType.toString());
            if (particle.getDataType() == Particle.DustOptions.class) {
                if (object2 instanceof Color) {
                    object2 = new Particle.DustOptions((Color)object2, 1.0f);
                } else if (object2 == null) {
                    object2 = new Particle.DustOptions(Color.RED, 1.0f);
                }
            } else if (particle.getDataType() == BlockData.class && object2 instanceof MaterialData) {
                object2 = Bukkit.createBlockData((Material)((MaterialData)object2).getItemType());
            }
            super.spawnParticle(object, particleType, d, d2, d3, n, d4, d5, d6, d7, object2);
        }

        @Override
        public boolean isValidDataBukkit(Particle particle, Object object) {
            if (particle.getDataType() == Particle.DustOptions.class && object instanceof Color) {
                return true;
            }
            if (particle.getDataType() == BlockData.class && object instanceof MaterialData) {
                return true;
            }
            return super.isValidDataBukkit(particle, object);
        }

        static {
            IBootstrap.dasBoot();
        }
    }

    public static class ParticleSenderImpl
    implements ParticleSender {
        @Override
        public void spawnParticle(Object object, ParticleType particleType, double d, double d2, double d3, int n, double d4, double d5, double d6, double d7, Object object2) {
            Particle particle = Particle.valueOf((String)particleType.toString());
            if (object2 instanceof Color) {
                if (particleType.getDataType() == Color.class) {
                    Color color = (Color)object2;
                    n = 0;
                    d4 = this.color(color.getRed());
                    d5 = this.color(color.getGreen());
                    d6 = this.color(color.getBlue());
                    d7 = 1.0;
                }
                object2 = null;
            }
            if (object instanceof World) {
                ((World)object).spawnParticle(particle, d, d2, d3, n, d4, d5, d6, d7, object2);
            } else if (object instanceof Player) {
                ((Player)object).spawnParticle(particle, d, d2, d3, n, d4, d5, d6, d7, object2);
            }
        }

        public Particle getParticle(ParticleType particleType) {
            try {
                return Particle.valueOf((String)particleType.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        @Override
        public boolean isValidData(Object object, Object object2) {
            return this.isValidDataBukkit((Particle)object, object2);
        }

        public boolean isValidDataBukkit(Particle particle, Object object) {
            return particle.getDataType() == Void.class || particle.getDataType().isInstance(object);
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

