/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.FastReflection;
import com.volmit.adapt.util.ParticleSender;
import com.volmit.adapt.util.ParticleType;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Color;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

class ParticleSenderLegacy
implements ParticleSender {
    private static final boolean SERVER_IS_1_8;
    private static final Constructor<?> PACKET_PARTICLE;
    private static final Class<?> ENUM_PARTICLE;
    private static final Method WORLD_GET_HANDLE;
    private static final Method WORLD_SEND_PARTICLE;
    private static final Method PLAYER_GET_HANDLE;
    private static final Field PLAYER_CONNECTION;
    private static final Method SEND_PACKET;
    private static final int[] EMPTY;

    ParticleSenderLegacy() {
    }

    @Override
    public void spawnParticle(Object object, ParticleType particleType, double d, double d2, double d3, int n, double d4, double d5, double d6, double d7, Object object2) {
        try {
            Object object3;
            int[] nArray = this.toData(particleType, object2);
            if (object2 instanceof Color && particleType.getDataType() == Color.class) {
                object3 = (Color)object2;
                n = 0;
                d4 = this.color(object3.getRed());
                d5 = this.color(object3.getGreen());
                d6 = this.color(object3.getBlue());
                d7 = 1.0;
            }
            if (object instanceof World) {
                object3 = WORLD_GET_HANDLE.invoke(object, new Object[0]);
                if (SERVER_IS_1_8) {
                    WORLD_SEND_PARTICLE.invoke(object3, null, this.getEnumParticle(particleType), true, d, d2, d3, n, d4, d5, d6, d7, nArray);
                } else {
                    String string = particleType.getLegacyName() + (String)(nArray.length != 2 ? "" : "_" + nArray[0] + "_" + nArray[1]);
                    WORLD_SEND_PARTICLE.invoke(object3, string, d, d2, d3, n, d4, d5, d6, d7);
                }
            } else if (object instanceof Player) {
                Object object4;
                if (SERVER_IS_1_8) {
                    object3 = PACKET_PARTICLE.newInstance(this.getEnumParticle(particleType), true, Float.valueOf((float)d), Float.valueOf((float)d2), Float.valueOf((float)d3), Float.valueOf((float)d4), Float.valueOf((float)d5), Float.valueOf((float)d6), Float.valueOf((float)d7), n, nArray);
                } else {
                    object4 = particleType.getLegacyName() + (String)(nArray.length != 2 ? "" : "_" + nArray[0] + "_" + nArray[1]);
                    object3 = PACKET_PARTICLE.newInstance(object4, Float.valueOf((float)d), Float.valueOf((float)d2), Float.valueOf((float)d3), Float.valueOf((float)d4), Float.valueOf((float)d5), Float.valueOf((float)d6), Float.valueOf((float)d7), n);
                }
                object4 = PLAYER_GET_HANDLE.invoke(object, new Object[0]);
                Object object5 = PLAYER_CONNECTION.get(object4);
                SEND_PACKET.invoke(object5, object3);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    @Override
    public boolean isValidData(Object object, Object object2) {
        return true;
    }

    @Override
    public Object getParticle(ParticleType particleType) {
        if (!SERVER_IS_1_8) {
            return particleType.getLegacyName();
        }
        try {
            return this.getEnumParticle(particleType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private Object getEnumParticle(ParticleType particleType) {
        return FastReflection.enumValueOf(ENUM_PARTICLE, particleType.toString());
    }

    private int[] toData(ParticleType particleType, Object object) {
        Class<?> clazz = particleType.getDataType();
        if (clazz == ItemStack.class) {
            if (!(object instanceof ItemStack)) {
                int[] nArray;
                if (SERVER_IS_1_8) {
                    nArray = new int[2];
                } else {
                    int[] nArray2 = new int[2];
                    nArray2[0] = 1;
                    nArray = nArray2;
                    nArray2[1] = 0;
                }
                return nArray;
            }
            ItemStack itemStack = (ItemStack)object;
            return new int[]{itemStack.getType().getId(), itemStack.getDurability()};
        }
        if (clazz == MaterialData.class) {
            if (!(object instanceof MaterialData)) {
                int[] nArray;
                if (SERVER_IS_1_8) {
                    nArray = new int[1];
                } else {
                    int[] nArray3 = new int[2];
                    nArray3[0] = 1;
                    nArray = nArray3;
                    nArray3[1] = 0;
                }
                return nArray;
            }
            MaterialData materialData = (MaterialData)object;
            if (SERVER_IS_1_8) {
                return new int[]{materialData.getItemType().getId() + (materialData.getData() << 12)};
            }
            return new int[]{materialData.getItemType().getId(), materialData.getData()};
        }
        return EMPTY;
    }

    static {
        IBootstrap.dasBoot();
        EMPTY = new int[0];
        ENUM_PARTICLE = FastReflection.nmsOptionalClass("EnumParticle").orElse(null);
        SERVER_IS_1_8 = ENUM_PARTICLE != null;
        try {
            Class<?> clazz = FastReflection.nmsClass("PacketPlayOutWorldParticles");
            Class<?> clazz2 = FastReflection.nmsClass("EntityPlayer");
            Class<?> clazz3 = FastReflection.nmsClass("PlayerConnection");
            Class<?> clazz4 = FastReflection.nmsClass("WorldServer");
            Class<?> clazz5 = FastReflection.nmsClass("EntityPlayer");
            Class<?> clazz6 = FastReflection.obcClass("entity.CraftPlayer");
            Class<?> clazz7 = FastReflection.obcClass("CraftWorld");
            if (SERVER_IS_1_8) {
                PACKET_PARTICLE = clazz.getConstructor(ENUM_PARTICLE, Boolean.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, int[].class);
                WORLD_SEND_PARTICLE = clazz4.getDeclaredMethod("sendParticles", clazz5, ENUM_PARTICLE, Boolean.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, int[].class);
            } else {
                PACKET_PARTICLE = clazz.getConstructor(String.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE);
                WORLD_SEND_PARTICLE = clazz4.getDeclaredMethod("a", String.class, Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            }
            WORLD_GET_HANDLE = clazz7.getDeclaredMethod("getHandle", new Class[0]);
            PLAYER_GET_HANDLE = clazz6.getDeclaredMethod("getHandle", new Class[0]);
            PLAYER_CONNECTION = clazz2.getField("playerConnection");
            SEND_PACKET = clazz3.getMethod("sendPacket", FastReflection.nmsClass("Packet"));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

