/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Objects;
import net.minecraft.resources.MinecraftKey;

public class NameKey {
    private final String namespace;
    private final String key;
    private transient MinecraftKey mcKey;

    public NameKey(String string, String string2) {
        this.namespace = string.toLowerCase();
        this.key = string2.toLowerCase();
    }

    public NameKey(String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length < 2) {
            this.namespace = "minecraft";
            this.key = string.toLowerCase();
        } else {
            this.namespace = stringArray[0].toLowerCase();
            this.key = string.replaceFirst(stringArray[0] + ":", "").toLowerCase();
        }
    }

    public NameKey(MinecraftKey minecraftKey) {
        this.namespace = minecraftKey.b().toLowerCase();
        this.key = minecraftKey.a().toLowerCase();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isSimilar(NameKey nameKey) {
        return this.namespace.equals(nameKey.getNamespace()) && this.key.equals(nameKey.getKey());
    }

    public MinecraftKey getMinecraftKey() {
        if (this.mcKey == null) {
            this.mcKey = new MinecraftKey(this.namespace, this.key);
        }
        return this.mcKey;
    }

    public boolean equals(Object object) {
        return this.isSimilar((NameKey)object);
    }

    public String toString() {
        return this.namespace + ":" + this.key;
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.key);
    }

    static {
        IBootstrap.dasBoot();
    }
}

