/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.amulet.range;

import com.volmit.adapt.util.arcane.amulet.range.NumberRange;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class BigDecimalRange
extends NumberRange<BigDecimal, BigDecimalRange> {
    public BigDecimalRange(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        this(bigDecimal, bigDecimal2, BigDecimal.ONE, true, true, false);
    }

    public BigDecimalRange unaryMinus() {
        BigDecimal bigDecimal = (BigDecimal)this.getLeftEndpoint();
        BigDecimal bigDecimal2 = (BigDecimal)this.getRightEndpoint();
        if (this.isReversed()) {
            return new BigDecimalRange(bigDecimal, bigDecimal2, (BigDecimal)this.getStep(), true, true, false);
        }
        return new BigDecimalRange(bigDecimal2, bigDecimal, (BigDecimal)this.getStep(), true, true, true);
    }

    public BigDecimalRange(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, boolean bl, boolean bl2, boolean bl3) {
        super(bigDecimal, bigDecimal2, bigDecimal3, bl, bl2, bl3);
        if (bigDecimal3.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("The step must be greater than 0: " + bigDecimal3);
        }
    }

    @Override
    public Iterator<BigDecimal> iterateFromLeft() {
        return new ForwardIterator();
    }

    @Override
    public Iterator<BigDecimal> iterateFromRight() {
        return new ReverseIterator();
    }

    @Override
    public BigDecimal getFromLeft(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + n);
        }
        if (!this.isLeftClosed()) {
            ++n;
        }
        BigDecimal bigDecimal = ((BigDecimal)this.getLeftEndpoint()).add(((BigDecimal)this.getStep()).multiply(BigDecimal.valueOf(n)));
        int n2 = bigDecimal.compareTo((BigDecimal)this.getRightEndpoint());
        if (this.isRightClosed() ? n2 <= 0 : n2 < 0) {
            return bigDecimal;
        }
        return null;
    }

    @Override
    public BigDecimal getFromRight(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + n);
        }
        if (!this.isRightClosed()) {
            ++n;
        }
        BigDecimal bigDecimal = ((BigDecimal)this.getRightEndpoint()).subtract(((BigDecimal)this.getStep()).multiply(BigDecimal.valueOf(n)));
        int n2 = bigDecimal.compareTo((BigDecimal)this.getLeftEndpoint());
        if (this.isLeftClosed() ? n2 >= 0 : n2 > 0) {
            return bigDecimal;
        }
        return null;
    }

    static {
        IBootstrap.dasBoot();
    }

    private class ForwardIterator
    implements Iterator<BigDecimal> {
        private BigDecimal _csr;

        public ForwardIterator() {
            this._csr = (BigDecimal)BigDecimalRange.this.getLeftEndpoint();
            if (!BigDecimalRange.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            int n = this._csr.compareTo((BigDecimal)BigDecimalRange.this.getRightEndpoint());
            return n < 0 || BigDecimalRange.this.isRightClosed() && n == 0;
        }

        @Override
        public BigDecimal next() {
            int n = this._csr.compareTo((BigDecimal)BigDecimalRange.this.getRightEndpoint());
            if (n > 0 || !BigDecimalRange.this.isRightClosed() && n == 0) {
                throw new NoSuchElementException();
            }
            BigDecimal bigDecimal = this._csr;
            this._csr = this._csr.add((BigDecimal)BigDecimalRange.this.getStep());
            return bigDecimal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ReverseIterator
    implements Iterator<BigDecimal> {
        private BigDecimal _csr;

        public ReverseIterator() {
            this._csr = (BigDecimal)BigDecimalRange.this.getRightEndpoint();
            if (!BigDecimalRange.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            int n = this._csr.compareTo((BigDecimal)BigDecimalRange.this.getLeftEndpoint());
            return n > 0 || BigDecimalRange.this.isLeftClosed() && n == 0;
        }

        @Override
        public BigDecimal next() {
            int n = this._csr.compareTo((BigDecimal)BigDecimalRange.this.getLeftEndpoint());
            if (n < 0 || !BigDecimalRange.this.isLeftClosed() && n == 0) {
                throw new NoSuchElementException();
            }
            BigDecimal bigDecimal = this._csr;
            this._csr = this._csr.subtract((BigDecimal)BigDecimalRange.this.getStep());
            return bigDecimal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

