/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util.poet;

import com.volmit.adapt.util.arcane.curse.util.poet.AnnotationSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.ClassName;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeBlock;
import com.volmit.adapt.util.arcane.curse.util.poet.LineWrapper;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeName;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeVariableName;
import com.volmit.adapt.util.arcane.curse.util.poet.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;

final class CodeWriter {
    private static final String NO_PACKAGE = "";
    private static final Pattern LINE_BREAKING_PATTERN = Pattern.compile("\\R");
    private final String indent;
    private final LineWrapper out;
    private int indentLevel;
    private boolean javadoc = false;
    private boolean comment = false;
    private String packageName = "";
    private final List<TypeSpec> typeSpecStack = new ArrayList<TypeSpec>();
    private final Set<String> staticImportClassNames;
    private final Set<String> staticImports;
    private final Set<String> alwaysQualify;
    private final Map<String, ClassName> importedTypes;
    private final Map<String, ClassName> importableTypes = new LinkedHashMap<String, ClassName>();
    private final Set<String> referencedNames = new LinkedHashSet<String>();
    private final Multiset<String> currentTypeVariables = new Multiset();
    private boolean trailingNewline;
    int statementLine = -1;

    CodeWriter(Appendable appendable) {
        this(appendable, "  ", Collections.emptySet(), Collections.emptySet());
    }

    CodeWriter(Appendable appendable, String string, Set<String> set, Set<String> set2) {
        this(appendable, string, Collections.emptyMap(), set, set2);
    }

    CodeWriter(Appendable appendable, String string, Map<String, ClassName> map, Set<String> set, Set<String> set2) {
        this.out = new LineWrapper(appendable, string, 100);
        this.indent = Util.checkNotNull(string, "indent == null", new Object[0]);
        this.importedTypes = Util.checkNotNull(map, "importedTypes == null", new Object[0]);
        this.staticImports = Util.checkNotNull(set, "staticImports == null", new Object[0]);
        this.alwaysQualify = Util.checkNotNull(set2, "alwaysQualify == null", new Object[0]);
        this.staticImportClassNames = new LinkedHashSet<String>();
        for (String string2 : set) {
            this.staticImportClassNames.add(string2.substring(0, string2.lastIndexOf(46)));
        }
    }

    public Map<String, ClassName> importedTypes() {
        return this.importedTypes;
    }

    public CodeWriter indent() {
        return this.indent(1);
    }

    public CodeWriter indent(int n) {
        this.indentLevel += n;
        return this;
    }

    public CodeWriter unindent() {
        return this.unindent(1);
    }

    public CodeWriter unindent(int n) {
        Util.checkArgument(this.indentLevel - n >= 0, "cannot unindent %s from %s", n, this.indentLevel);
        this.indentLevel -= n;
        return this;
    }

    public CodeWriter pushPackage(String string) {
        Util.checkState(this.packageName == NO_PACKAGE, "package already set: %s", this.packageName);
        this.packageName = Util.checkNotNull(string, "packageName == null", new Object[0]);
        return this;
    }

    public CodeWriter popPackage() {
        Util.checkState(this.packageName != NO_PACKAGE, "package not set", new Object[0]);
        this.packageName = NO_PACKAGE;
        return this;
    }

    public CodeWriter pushType(TypeSpec typeSpec) {
        this.typeSpecStack.add(typeSpec);
        return this;
    }

    public CodeWriter popType() {
        this.typeSpecStack.remove(this.typeSpecStack.size() - 1);
        return this;
    }

    public void emitComment(CodeBlock codeBlock) {
        this.trailingNewline = true;
        this.comment = true;
        try {
            this.emit(codeBlock);
            this.emit("\n");
        }
        finally {
            this.comment = false;
        }
    }

    public void emitJavadoc(CodeBlock codeBlock) {
        if (codeBlock.isEmpty()) {
            return;
        }
        this.emit("/**\n");
        this.javadoc = true;
        try {
            this.emit(codeBlock, true);
        }
        finally {
            this.javadoc = false;
        }
        this.emit(" */\n");
    }

    public void emitAnnotations(List<AnnotationSpec> list, boolean bl) {
        for (AnnotationSpec annotationSpec : list) {
            annotationSpec.emit(this, bl);
            this.emit(bl ? " " : "\n");
        }
    }

    public void emitModifiers(Set<Modifier> set, Set<Modifier> set2) {
        if (set.isEmpty()) {
            return;
        }
        for (Modifier modifier : EnumSet.copyOf(set)) {
            if (set2.contains((Object)modifier)) continue;
            this.emitAndIndent(modifier.name().toLowerCase(Locale.US));
            this.emitAndIndent(" ");
        }
    }

    public void emitModifiers(Set<Modifier> set) {
        this.emitModifiers(set, Collections.emptySet());
    }

    public void emitTypeVariables(List<TypeVariableName> list) {
        if (list.isEmpty()) {
            return;
        }
        list.forEach(typeVariableName -> this.currentTypeVariables.add(typeVariableName.name));
        this.emit("<");
        boolean bl = true;
        for (TypeVariableName typeVariableName2 : list) {
            if (!bl) {
                this.emit(", ");
            }
            this.emitAnnotations(typeVariableName2.annotations, true);
            this.emit("$L", typeVariableName2.name);
            boolean bl2 = true;
            for (TypeName typeName : typeVariableName2.bounds) {
                this.emit(bl2 ? " extends $T" : " & $T", typeName);
                bl2 = false;
            }
            bl = false;
        }
        this.emit(">");
    }

    public void popTypeVariables(List<TypeVariableName> list) {
        list.forEach(typeVariableName -> this.currentTypeVariables.remove(typeVariableName.name));
    }

    public CodeWriter emit(String string) {
        return this.emitAndIndent(string);
    }

    public CodeWriter emit(String string, Object ... objectArray) {
        return this.emit(CodeBlock.of(string, objectArray));
    }

    public CodeWriter emit(CodeBlock codeBlock) {
        return this.emit(codeBlock, false);
    }

    public CodeWriter emit(CodeBlock codeBlock, boolean bl) {
        int n = 0;
        ClassName className = null;
        ListIterator<String> listIterator = codeBlock.formatParts.listIterator();
        block26: while (listIterator.hasNext()) {
            String string;
            switch (string = listIterator.next()) {
                case "$L": {
                    this.emitLiteral(codeBlock.args.get(n++));
                    continue block26;
                }
                case "$N": {
                    this.emitAndIndent((String)codeBlock.args.get(n++));
                    continue block26;
                }
                case "$S": {
                    String string2 = (String)codeBlock.args.get(n++);
                    this.emitAndIndent(string2 != null ? Util.stringLiteralWithDoubleQuotes(string2, this.indent) : "null");
                    continue block26;
                }
                case "$T": {
                    TypeName typeName = (TypeName)codeBlock.args.get(n++);
                    if (typeName instanceof ClassName && listIterator.hasNext() && !codeBlock.formatParts.get(listIterator.nextIndex()).startsWith("$")) {
                        ClassName className2 = (ClassName)typeName;
                        if (this.staticImportClassNames.contains(className2.canonicalName)) {
                            Util.checkState(className == null, "pending type for static import?!", new Object[0]);
                            className = className2;
                            continue block26;
                        }
                    }
                    typeName.emit(this);
                    continue block26;
                }
                case "$$": {
                    this.emitAndIndent("$");
                    continue block26;
                }
                case "$>": {
                    this.indent();
                    continue block26;
                }
                case "$<": {
                    this.unindent();
                    continue block26;
                }
                case "$[": {
                    Util.checkState(this.statementLine == -1, "statement enter $[ followed by statement enter $[", new Object[0]);
                    this.statementLine = 0;
                    continue block26;
                }
                case "$]": {
                    Util.checkState(this.statementLine != -1, "statement exit $] has no matching statement enter $[", new Object[0]);
                    if (this.statementLine > 0) {
                        this.unindent(2);
                    }
                    this.statementLine = -1;
                    continue block26;
                }
                case "$W": {
                    this.out.wrappingSpace(this.indentLevel + 2);
                    continue block26;
                }
                case "$Z": {
                    this.out.zeroWidthSpace(this.indentLevel + 2);
                    continue block26;
                }
            }
            if (className != null) {
                if (string.startsWith(".") && this.emitStaticImportMember(className.canonicalName, string)) {
                    className = null;
                    continue;
                }
                className.emit(this);
                className = null;
            }
            this.emitAndIndent(string);
        }
        if (bl && this.out.lastChar() != '\n') {
            this.emit("\n");
        }
        return this;
    }

    public CodeWriter emitWrappingSpace() {
        this.out.wrappingSpace(this.indentLevel + 2);
        return this;
    }

    private static String extractMemberName(String string) {
        Util.checkArgument(Character.isJavaIdentifierStart(string.charAt(0)), "not an identifier: %s", string);
        for (int i = 1; i <= string.length(); ++i) {
            if (SourceVersion.isIdentifier(string.substring(0, i))) continue;
            return string.substring(0, i - 1);
        }
        return string;
    }

    private boolean emitStaticImportMember(String string, String string2) {
        String string3 = string2.substring(1);
        if (string3.isEmpty()) {
            return false;
        }
        char c = string3.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return false;
        }
        String string4 = string + "." + CodeWriter.extractMemberName(string3);
        String string5 = string + ".*";
        if (this.staticImports.contains(string4) || this.staticImports.contains(string5)) {
            this.emitAndIndent(string3);
            return true;
        }
        return false;
    }

    private void emitLiteral(Object object) {
        if (object instanceof TypeSpec) {
            TypeSpec typeSpec = (TypeSpec)object;
            typeSpec.emit(this, null, Collections.emptySet());
        } else if (object instanceof AnnotationSpec) {
            AnnotationSpec annotationSpec = (AnnotationSpec)object;
            annotationSpec.emit(this, true);
        } else if (object instanceof CodeBlock) {
            CodeBlock codeBlock = (CodeBlock)object;
            this.emit(codeBlock);
        } else {
            this.emitAndIndent(String.valueOf(object));
        }
    }

    String lookupName(ClassName className) {
        String string = className.topLevelClassName().simpleName();
        if (this.currentTypeVariables.contains(string)) {
            return className.canonicalName;
        }
        boolean bl = false;
        for (ClassName className2 = className; className2 != null; className2 = className2.enclosingClassName()) {
            ClassName className3 = this.resolve(className2.simpleName());
            boolean bl2 = bl = className3 != null;
            if (className3 == null || !Objects.equals(className3.canonicalName, className2.canonicalName)) continue;
            int n = className2.simpleNames().size() - 1;
            return String.join((CharSequence)".", className.simpleNames().subList(n, className.simpleNames().size()));
        }
        if (bl) {
            return className.canonicalName;
        }
        if (Objects.equals(this.packageName, className.packageName())) {
            this.referencedNames.add(string);
            return String.join((CharSequence)".", className.simpleNames());
        }
        if (!this.javadoc) {
            this.importableType(className);
        }
        return className.canonicalName;
    }

    private void importableType(ClassName className) {
        if (className.packageName().isEmpty()) {
            return;
        }
        if (this.alwaysQualify.contains(className.simpleName)) {
            return;
        }
        ClassName className2 = className.topLevelClassName();
        String string = className2.simpleName();
        ClassName className3 = this.importableTypes.put(string, className2);
        if (className3 != null) {
            this.importableTypes.put(string, className3);
        }
    }

    private ClassName resolve(String string) {
        for (int i = this.typeSpecStack.size() - 1; i >= 0; --i) {
            TypeSpec typeSpec = this.typeSpecStack.get(i);
            if (!typeSpec.nestedTypesSimpleNames.contains(string)) continue;
            return this.stackClassName(i, string);
        }
        if (this.typeSpecStack.size() > 0 && Objects.equals(this.typeSpecStack.get((int)0).name, string)) {
            return ClassName.get(this.packageName, string, new String[0]);
        }
        ClassName className = this.importedTypes.get(string);
        return className;
    }

    private ClassName stackClassName(int n, String string) {
        ClassName className = ClassName.get(this.packageName, this.typeSpecStack.get((int)0).name, new String[0]);
        for (int i = 1; i <= n; ++i) {
            className = className.nestedClass(this.typeSpecStack.get((int)i).name);
        }
        return className.nestedClass(string);
    }

    CodeWriter emitAndIndent(String string) {
        boolean bl = true;
        for (String string2 : LINE_BREAKING_PATTERN.split(string, -1)) {
            if (!bl) {
                if ((this.javadoc || this.comment) && this.trailingNewline) {
                    this.emitIndentation();
                    this.out.append(this.javadoc ? " *" : "//");
                }
                this.out.append("\n");
                this.trailingNewline = true;
                if (this.statementLine != -1) {
                    if (this.statementLine == 0) {
                        this.indent(2);
                    }
                    ++this.statementLine;
                }
            }
            bl = false;
            if (string2.isEmpty()) continue;
            if (this.trailingNewline) {
                this.emitIndentation();
                if (this.javadoc) {
                    this.out.append(" * ");
                } else if (this.comment) {
                    this.out.append("// ");
                }
            }
            this.out.append(string2);
            this.trailingNewline = false;
        }
        return this;
    }

    private void emitIndentation() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.out.append(this.indent);
        }
    }

    Map<String, ClassName> suggestedImports() {
        LinkedHashMap<String, ClassName> linkedHashMap = new LinkedHashMap<String, ClassName>(this.importableTypes);
        linkedHashMap.keySet().removeAll(this.referencedNames);
        return linkedHashMap;
    }

    private static final class Multiset<T> {
        private final Map<T, Integer> map = new LinkedHashMap<T, Integer>();

        private Multiset() {
        }

        void add(T t) {
            int n = this.map.getOrDefault(t, 0);
            this.map.put(t, n + 1);
        }

        void remove(T t) {
            int n = this.map.getOrDefault(t, 0);
            if (n == 0) {
                throw new IllegalStateException(t + " is not in the multiset");
            }
            this.map.put(t, n - 1);
        }

        boolean contains(T t) {
            return this.map.getOrDefault(t, 0) > 0;
        }
    }
}

