/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util.poet;

import com.volmit.adapt.util.arcane.curse.util.poet.AnnotationSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.ClassName;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeBlock;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeWriter;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeName;
import com.volmit.adapt.util.arcane.curse.util.poet.Util;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

public final class ParameterSpec {
    public final String name;
    public final List<AnnotationSpec> annotations;
    public final Set<Modifier> modifiers;
    public final TypeName type;
    public final CodeBlock javadoc;

    private ParameterSpec(Builder builder) {
        this.name = Util.checkNotNull(builder.name, "name == null", new Object[0]);
        this.annotations = Util.immutableList(builder.annotations);
        this.modifiers = Util.immutableSet(builder.modifiers);
        this.type = Util.checkNotNull(builder.type, "type == null", new Object[0]);
        this.javadoc = builder.javadoc.build();
    }

    public boolean hasModifier(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    void emit(CodeWriter codeWriter, boolean bl) {
        codeWriter.emitAnnotations(this.annotations, true);
        codeWriter.emitModifiers(this.modifiers);
        if (bl) {
            TypeName.asArray(this.type).emit(codeWriter, true);
        } else {
            this.type.emit(codeWriter);
        }
        codeWriter.emit(" $L", this.name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            CodeWriter codeWriter = new CodeWriter(stringBuilder);
            this.emit(codeWriter, false);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    public static ParameterSpec get(VariableElement variableElement) {
        Util.checkArgument(variableElement.getKind().equals((Object)ElementKind.PARAMETER), "element is not a parameter", new Object[0]);
        TypeName typeName = TypeName.get(variableElement.asType());
        String string = variableElement.getSimpleName().toString();
        return ParameterSpec.builder(typeName, string, new Modifier[0]).addModifiers(variableElement.getModifiers()).build();
    }

    static List<ParameterSpec> parametersOf(ExecutableElement executableElement) {
        ArrayList<ParameterSpec> arrayList = new ArrayList<ParameterSpec>();
        for (VariableElement variableElement : executableElement.getParameters()) {
            arrayList.add(ParameterSpec.get(variableElement));
        }
        return arrayList;
    }

    private static boolean isValidParameterName(String string) {
        if (string.endsWith(".this")) {
            return SourceVersion.isIdentifier(string.substring(0, string.length() - ".this".length()));
        }
        return string.equals("this") || SourceVersion.isName(string);
    }

    public static Builder builder(TypeName typeName, String string, Modifier ... modifierArray) {
        Util.checkNotNull(typeName, "type == null", new Object[0]);
        Util.checkArgument(ParameterSpec.isValidParameterName(string), "not a valid name: %s", string);
        return new Builder(typeName, string).addModifiers(modifierArray);
    }

    public static Builder builder(Type type, String string, Modifier ... modifierArray) {
        return ParameterSpec.builder(TypeName.get(type), string, modifierArray);
    }

    public Builder toBuilder() {
        return this.toBuilder(this.type, this.name);
    }

    Builder toBuilder(TypeName typeName, String string) {
        Builder builder = new Builder(typeName, string);
        builder.annotations.addAll(this.annotations);
        builder.modifiers.addAll(this.modifiers);
        return builder;
    }

    public static final class Builder {
        private final TypeName type;
        private final String name;
        private final CodeBlock.Builder javadoc = CodeBlock.builder();
        public final List<AnnotationSpec> annotations = new ArrayList<AnnotationSpec>();
        public final List<Modifier> modifiers = new ArrayList<Modifier>();

        private Builder(TypeName typeName, String string) {
            this.type = typeName;
            this.name = string;
        }

        public Builder addJavadoc(String string, Object ... objectArray) {
            this.javadoc.add(string, objectArray);
            return this;
        }

        public Builder addJavadoc(CodeBlock codeBlock) {
            this.javadoc.add(codeBlock);
            return this;
        }

        public Builder addAnnotations(Iterable<AnnotationSpec> iterable) {
            Util.checkArgument(iterable != null, "annotationSpecs == null", new Object[0]);
            for (AnnotationSpec annotationSpec : iterable) {
                this.annotations.add(annotationSpec);
            }
            return this;
        }

        public Builder addAnnotation(AnnotationSpec annotationSpec) {
            this.annotations.add(annotationSpec);
            return this;
        }

        public Builder addAnnotation(ClassName className) {
            this.annotations.add(AnnotationSpec.builder(className).build());
            return this;
        }

        public Builder addAnnotation(Class<?> clazz) {
            return this.addAnnotation(ClassName.get(clazz));
        }

        public Builder addModifiers(Modifier ... modifierArray) {
            Collections.addAll(this.modifiers, modifierArray);
            return this;
        }

        public Builder addModifiers(Iterable<Modifier> iterable) {
            Util.checkNotNull(iterable, "modifiers == null", new Object[0]);
            for (Modifier modifier : iterable) {
                if (!modifier.equals((Object)Modifier.FINAL)) {
                    throw new IllegalStateException("unexpected parameter modifier: " + modifier);
                }
                this.modifiers.add(modifier);
            }
            return this;
        }

        public ParameterSpec build() {
            return new ParameterSpec(this);
        }
    }
}

