/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.multiburst;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class BurstExecutor {
    private final ExecutorService executor;
    private final List<Future<?>> futures;
    private boolean multicore = true;

    public BurstExecutor(ExecutorService executorService, int n) {
        this.executor = executorService;
        this.futures = new ArrayList(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> queue(Runnable runnable) {
        if (!this.multicore) {
            runnable.run();
            return CompletableFuture.completedFuture(null);
        }
        List<Future<?>> list = this.futures;
        synchronized (list) {
            Future<?> future = this.executor.submit(runnable);
            this.futures.add(future);
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BurstExecutor queue(List<Runnable> list) {
        if (!this.multicore) {
            for (Runnable runnable : new ArrayList<Runnable>(list)) {
                runnable.run();
            }
            return this;
        }
        List<Future<?>> list2 = this.futures;
        synchronized (list2) {
            for (Runnable runnable : new ArrayList<Runnable>(list)) {
                this.queue(runnable);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BurstExecutor queue(Runnable[] runnableArray) {
        if (!this.multicore) {
            for (Runnable runnable : runnableArray) {
                runnable.run();
            }
            return this;
        }
        List<Future<?>> list = this.futures;
        synchronized (list) {
            for (Runnable runnable : runnableArray) {
                this.queue(runnable);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        if (!this.multicore) {
            return;
        }
        List<Future<?>> list = this.futures;
        synchronized (list) {
            if (this.futures.isEmpty()) {
                return;
            }
            try {
                for (Future<?> future : this.futures) {
                    future.get();
                }
                this.futures.clear();
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setMulticore(boolean bl) {
        this.multicore = bl;
    }
}

