/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.container.DataContainer;
import com.volmit.adapt.util.arcane.spatial.container.NodeWritable;
import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import com.volmit.adapt.util.arcane.spatial.util.Consume;

public class PaletteHunk<T>
extends StorageHunk<T>
implements Hunk<T> {
    private DataContainer<T> data;

    public PaletteHunk(int n, int n2, int n3, NodeWritable<T> nodeWritable) {
        super(n, n2, n3);
        this.data = new DataContainer<T>(nodeWritable, n * n2 * n3);
    }

    public void setPalette(DataContainer<T> dataContainer) {
        this.data = dataContainer;
    }

    @Override
    public boolean isMapped() {
        return false;
    }

    private int index(int n, int n2, int n3) {
        return n3 * this.getWidth() * this.getHeight() + n2 * this.getWidth() + n;
    }

    @Override
    public synchronized Hunk<T> iterateSync(Consume.Four<Integer, Integer, Integer, T> four) {
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                for (int k = 0; k < this.getDepth(); ++k) {
                    T t = this.getRaw(i, j, k);
                    if (t == null) continue;
                    four.accept(i, j, k, t);
                }
            }
        }
        return this;
    }

    @Override
    public synchronized Hunk<T> iterateSyncIO(Consume.FourIO<Integer, Integer, Integer, T> fourIO) {
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                for (int k = 0; k < this.getDepth(); ++k) {
                    T t = this.getRaw(i, j, k);
                    if (t == null) continue;
                    fourIO.accept(i, j, k, t);
                }
            }
        }
        return this;
    }

    @Override
    public void setRaw(int n, int n2, int n3, T t) {
        this.data.set(this.index(n, n2, n3), t);
    }

    @Override
    public T getRaw(int n, int n2, int n3) {
        return this.data.get(this.index(n, n2, n3));
    }

    public DataContainer<T> getData() {
        return this.data;
    }

    public void setData(DataContainer<T> dataContainer) {
        this.data = dataContainer;
    }

    @Override
    public String toString() {
        return "PaletteHunk(data=" + this.getData() + ")";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PaletteHunk)) {
            return false;
        }
        PaletteHunk paletteHunk = (PaletteHunk)object;
        if (!paletteHunk.canEqual(this)) {
            return false;
        }
        DataContainer<T> dataContainer = this.getData();
        DataContainer<T> dataContainer2 = paletteHunk.getData();
        return !(dataContainer == null ? dataContainer2 != null : !dataContainer.equals(dataContainer2));
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof PaletteHunk;
    }

    @Override
    public int hashCode() {
        int n = 59;
        int n2 = 1;
        DataContainer<T> dataContainer = this.getData();
        n2 = n2 * 59 + (dataContainer == null ? 43 : dataContainer.hashCode());
        return n2;
    }
}

