/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.matter;

import com.volmit.adapt.util.arcane.spatial.container.DataContainer;
import com.volmit.adapt.util.arcane.spatial.container.NodeWritable;
import com.volmit.adapt.util.arcane.spatial.container.Palette;
import com.volmit.adapt.util.arcane.spatial.container.PaletteType;
import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.PaletteOrHunk;
import com.volmit.adapt.util.arcane.spatial.matter.Matter;
import com.volmit.adapt.util.arcane.spatial.matter.MatterFilter;
import com.volmit.adapt.util.arcane.spatial.matter.MatterPalette;
import com.volmit.adapt.util.arcane.spatial.matter.MatterReader;
import com.volmit.adapt.util.arcane.spatial.matter.MatterWriter;
import com.volmit.adapt.util.arcane.spatial.util.CompressedNumbers;
import com.volmit.adapt.util.arcane.spatial.util.Pos;
import com.volmit.adapt.util.arcane.spatial.util.Varint;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public interface MatterSlice<T>
extends Hunk<T>,
PaletteType<T>,
NodeWritable<T> {
    public Class<T> getType();

    default public Palette<T> getGlobalPalette() {
        return null;
    }

    @Override
    default public void writePaletteNode(DataOutputStream dos, T s) throws IOException {
        this.writeNode(s, dos);
    }

    @Override
    default public void writeNodeData(DataOutputStream dos, T s) throws IOException {
        this.writeNode(s, dos);
    }

    @Override
    default public T readPaletteNode(DataInputStream din) throws IOException {
        return this.readNode(din);
    }

    @Override
    default public T readNodeData(DataInputStream din) throws IOException {
        return this.readNode(din);
    }

    default public void applyFilter(MatterFilter<T> filter) {
        this.updateSync(filter::update);
    }

    default public void inject(MatterSlice<T> slice) {
        this.iterateSync(slice::set);
    }

    default public void forceInject(MatterSlice<?> slice) {
        this.inject(slice);
    }

    public void writeNode(T var1, DataOutputStream var2) throws IOException;

    public T readNode(DataInputStream var1) throws IOException;

    public <W> MatterWriter<W, T> writeInto(Class<W> var1);

    public <W> MatterReader<W, T> readFrom(Class<W> var1);

    default public Class<?> getClass(Object w) {
        return w.getClass();
    }

    default public <W> boolean writeInto(W w, int x, int y, int z) {
        MatterWriter injector = this.writeInto(this.getClass(w));
        if (injector == null) {
            return false;
        }
        this.iterateSync((Integer a2, Integer b, Integer c, T t) -> injector.writeMatter(w, t, a2 + x, b + y, c + z));
        return true;
    }

    default public <W> boolean readFrom(W w, int x, int y, int z) {
        MatterReader<?, T> ejector = this.readFrom(this.getClass(w));
        if (ejector == null) {
            return false;
        }
        for (int i = x; i < x + this.getWidth(); ++i) {
            for (int j = y; j < y + this.getHeight(); ++j) {
                for (int k = z; k < z + this.getDepth(); ++k) {
                    T v = ejector.readMatter(w, i, j, k);
                    if (v == null) continue;
                    this.set(i - x, j - y, k - z, v);
                }
            }
        }
        return true;
    }

    default public boolean canWrite(Class<?> mediumType) {
        return this.writeInto(mediumType) != null;
    }

    default public boolean canRead(Class<?> mediumType) {
        return this.readFrom(mediumType) != null;
    }

    default public int getBitsPer(int needed) {
        int target = 1;
        for (int i = 1; i < 8; ++i) {
            if (!(Math.pow(2.0, i) > (double)needed)) continue;
            target = i;
            break;
        }
        return target;
    }

    default public void write(DataOutputStream dos) throws IOException {
        PaletteOrHunk f;
        dos.writeUTF(this.getType().getCanonicalName());
        MatterSlice matterSlice = this;
        if (matterSlice instanceof PaletteOrHunk && (f = (PaletteOrHunk)((Object)matterSlice)).isPalette()) {
            f.palette().writeDos(dos);
            return;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        MatterPalette palette = new MatterPalette(this);
        this.iterateSync((Integer x, Integer y, Integer z, T b) -> palette.assign(b));
        palette.writePalette(dos);
        dos.writeBoolean(this.isMapped());
        if (this.isMapped()) {
            Varint.writeUnsignedVarInt(this.getEntryCount(), dos);
            this.iterateSyncIO((x, y, z, b) -> {
                Varint.writeUnsignedVarInt(CompressedNumbers.index3Dto1D(x, y, z, w, h), dos);
                palette.writeNode(b, dos);
            });
        } else {
            this.iterateSyncIO((x, y, z, b) -> palette.writeNode(b, dos));
        }
    }

    default public void read(DataInputStream din) throws IOException {
        PaletteOrHunk f;
        MatterSlice matterSlice = this;
        if (matterSlice instanceof PaletteOrHunk && (f = (PaletteOrHunk)((Object)matterSlice)).isPalette()) {
            f.setPalette(new DataContainer(din, this));
            return;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        MatterPalette palette = new MatterPalette(this, din);
        if (din.readBoolean()) {
            int nodes = Varint.readUnsignedVarInt(din);
            while (nodes-- > 0) {
                int[] pos = CompressedNumbers.index1Dto3D(Varint.readUnsignedVarInt(din), w, h);
                this.setRaw(pos[0], pos[1], pos[2], palette.readNode(din));
            }
        } else {
            this.iterateSyncIO((x, y, z, b) -> this.setRaw((int)x, (int)y, (int)z, palette.readNode(din)));
        }
    }

    default public void rotateSliceInto(Matter n, double x, double y, double z) {
        this.rotate(x, y, z, (_x, _y, _z) -> n.slice(this.getType()));
    }

    default public boolean containsKey(Pos v) {
        return this.get(v.getX(), v.getY(), v.getZ()) != null;
    }

    default public void put(Pos v, T d) {
        this.set(v.getX(), v.getY(), v.getZ(), d);
    }

    default public T get(Pos v) {
        return this.get(v.getX(), v.getY(), v.getZ());
    }
}

