/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.advancement;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.advancement.AchievementAdvancement;
import com.hm.achievement.advancement.AdvancementJsonHelper;
import com.hm.achievement.advancement.AdvancementType;
import com.hm.achievement.category.Category;
import com.hm.achievement.category.CommandAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.domain.Achievement;
import com.hm.achievement.gui.GUIItems;
import com.hm.achievement.gui.OrderedCategory;
import com.hm.achievement.lifecycle.Reloadable;
import com.hm.achievement.utils.StringHelper;
import com.hm.apache.commons.lang3.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

@Singleton
public class AdvancementManager
implements Reloadable {
    public static final String ADVANCED_ACHIEVEMENTS_PARENT = "advanced_achievements_parent";
    private static final String MINECRAFT_BOOK_KEY = "minecraft:book";
    private static final Pattern REGEX_PATTERN_KEYS = Pattern.compile("[^A-Za-z0-9_]");
    private final YamlConfiguration mainConfig;
    private final GUIItems guiItems;
    private final AdvancedAchievements advancedAchievements;
    private final Logger logger;
    private final Set<Category> disabledCategories;
    private final AchievementMap achievementMap;
    private boolean configRegisterAdvancementDescriptions;
    private boolean configHideAdvancements;
    private String configRootAdvancementTitle;
    private String configBackgroundTexture;
    private int generatedAdvancements;

    @Inject
    public AdvancementManager(@Named(value="main") YamlConfiguration yamlConfiguration, GUIItems gUIItems, AchievementMap achievementMap, AdvancedAchievements advancedAchievements, Logger logger, Set<Category> set) {
        this.mainConfig = yamlConfiguration;
        this.guiItems = gUIItems;
        this.advancedAchievements = advancedAchievements;
        this.logger = logger;
        this.disabledCategories = set;
        this.achievementMap = achievementMap;
    }

    @Override
    public void extractConfigurationParameters() {
        this.configRegisterAdvancementDescriptions = this.mainConfig.getBoolean("RegisterAdvancementDescriptions");
        this.configHideAdvancements = this.mainConfig.getBoolean("HideAdvancements");
        this.configRootAdvancementTitle = this.mainConfig.getString("RootAdvancementTitle");
        this.configBackgroundTexture = this.mainConfig.getString("AdvancementsBackground");
    }

    public static String getKey(String string) {
        return REGEX_PATTERN_KEYS.matcher(string).replaceAll("").toLowerCase();
    }

    public void registerAdvancements() {
        this.cleanupOldAchievementAdvancements();
        this.registerParentAdvancement();
        this.registerOtherAdvancements();
    }

    private void cleanupOldAchievementAdvancements() {
        int n = 0;
        Iterator iterator = Bukkit.advancementIterator();
        while (iterator.hasNext()) {
            NamespacedKey namespacedKey = ((Advancement)iterator.next()).getKey();
            if (!"advancedachievements".equals(namespacedKey.getNamespace())) continue;
            ++n;
            Bukkit.getUnsafe().removeAdvancement(namespacedKey);
        }
        Bukkit.reloadData();
        this.logger.info("Cleaned " + n + " old advancements.");
    }

    private void registerParentAdvancement() {
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.advancedAchievements, ADVANCED_ACHIEVEMENTS_PARENT);
        if (Bukkit.getAdvancement((NamespacedKey)namespacedKey) == null) {
            if (this.configHideAdvancements) {
                Bukkit.getUnsafe().loadAdvancement(namespacedKey, AdvancementJsonHelper.toHiddenJson(this.configBackgroundTexture));
            } else {
                AchievementAdvancement.AchievementAdvancementBuilder achievementAdvancementBuilder = new AchievementAdvancement.AchievementAdvancementBuilder().iconItem(MINECRAFT_BOOK_KEY).title(this.configRootAdvancementTitle).description("").background(this.configBackgroundTexture).type(AdvancementType.GOAL);
                Bukkit.getUnsafe().loadAdvancement(namespacedKey, AdvancementJsonHelper.toJson(achievementAdvancementBuilder.build()));
            }
        }
    }

    private void registerOtherAdvancements() {
        this.generatedAdvancements = 1;
        for (Map.Entry<OrderedCategory, ItemStack> entry : this.guiItems.getOrderedAchievementItems().entrySet()) {
            Category category = entry.getKey().getCategory();
            if (this.disabledCategories.contains(category)) continue;
            ItemStack itemStack = entry.getValue();
            String string = ADVANCED_ACHIEVEMENTS_PARENT;
            List<Achievement> list = this.achievementMap.getForCategory(category);
            for (int i = 0; i < list.size(); ++i) {
                Achievement achievement = list.get(i);
                boolean bl = achievement.getCategory() == CommandAchievements.COMMANDS || i == list.size() - 1 || !achievement.getSubcategory().equals(list.get(i + 1).getSubcategory());
                string = this.registerAdvancement(itemStack, list.get(i), string, bl);
            }
        }
        Bukkit.reloadData();
        this.logger.info("Generated " + this.generatedAdvancements + " new advancements.");
    }

    private String registerAdvancement(ItemStack itemStack, Achievement achievement, String string, boolean bl) {
        String string2 = StringHelper.removeFormattingCodes(achievement.getDisplayName());
        String string3 = AdvancementManager.getKey(achievement.getName());
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.advancedAchievements, string3);
        String string4 = "";
        if (this.configRegisterAdvancementDescriptions) {
            string4 = StringHelper.removeFormattingCodes(StringUtils.replace(achievement.getGoal(), "\\n", " "));
        }
        AchievementAdvancement.AchievementAdvancementBuilder achievementAdvancementBuilder = new AchievementAdvancement.AchievementAdvancementBuilder().iconItem(itemStack.getType().name().toLowerCase()).title(string2).description(string4).parent("advancedachievements:" + string).type(bl ? AdvancementType.CHALLENGE : AdvancementType.TASK);
        Bukkit.getUnsafe().loadAdvancement(namespacedKey, AdvancementJsonHelper.toJson(achievementAdvancementBuilder.build()));
        ++this.generatedAdvancements;
        return string3;
    }
}

