/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.completer;

import com.hm.achievement.category.CommandAchievements;
import com.hm.achievement.command.executable.AbstractCommand;
import com.hm.achievement.command.executable.CommandSpec;
import com.hm.achievement.command.executable.EasterEggCommand;
import com.hm.achievement.config.AchievementMap;
import com.hm.apache.commons.lang3.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class CommandTabCompleter
implements TabCompleter {
    private final AchievementMap achievementMap;
    private final Set<CommandSpec> commandSpecs;

    @Inject
    public CommandTabCompleter(AchievementMap achievementMap, Set<AbstractCommand> set) {
        this.achievementMap = achievementMap;
        this.commandSpecs = set.stream().filter(abstractCommand -> !(abstractCommand instanceof EasterEggCommand)).map(abstractCommand -> abstractCommand.getClass().getAnnotation(CommandSpec.class)).collect(Collectors.toSet());
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (this.shouldReturnPlayerList(command, stringArray)) {
            return null;
        }
        String string2 = stringArray[0];
        Collection<Object> collection = Collections.emptyList();
        if (stringArray.length == 2 && "reset".equalsIgnoreCase(string2)) {
            collection = new HashSet<String>(this.achievementMap.getCategorySubcategories());
            collection.add("*");
        } else if (stringArray.length == 2 && "give".equalsIgnoreCase(string2)) {
            collection = this.achievementMap.getSubcategoriesForCategory(CommandAchievements.COMMANDS);
        } else if (stringArray.length == 2 && "check".equalsIgnoreCase(string2)) {
            collection = this.achievementMap.getAllNames();
        } else if (stringArray.length == 2 && "delete".equalsIgnoreCase(string2)) {
            collection = new HashSet<String>(this.achievementMap.getAllNames());
            collection.add("*");
        } else if (stringArray.length == 2 && "inspect".equalsIgnoreCase(string2)) {
            collection = this.achievementMap.getAllSanitisedDisplayNames();
        } else if (stringArray.length == 2 && "add".equalsIgnoreCase(string2)) {
            collection = Collections.singleton("1");
        } else if (stringArray.length == 3 && "add".equalsIgnoreCase(string2)) {
            collection = this.achievementMap.getCategorySubcategories();
        } else if (stringArray.length == 1) {
            collection = this.commandSpecs.stream().filter(commandSpec -> commandSpec.permission().isEmpty() || commandSender.hasPermission("achievement." + commandSpec.permission())).map(CommandSpec::name).collect(Collectors.toSet());
        }
        return this.getPartialList(collection, stringArray[stringArray.length - 1]);
    }

    private List<String> getPartialList(Collection<String> collection, String string3) {
        return collection.stream().filter(string2 -> string2.toLowerCase().startsWith(string3.toLowerCase())).map(string -> string.replace(' ', '\u2423')).sorted().collect(Collectors.toList());
    }

    private boolean shouldReturnPlayerList(Command command, String[] stringArray) {
        return !"aach".equals(command.getName()) || stringArray.length == 3 && StringUtils.equalsAnyIgnoreCase(stringArray[0], "give", "reset", "check", "delete") || stringArray.length == 4 && "add".equalsIgnoreCase(stringArray[0]);
    }
}

