/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executable;

import com.hm.achievement.command.executable.AbstractCommand;
import com.hm.achievement.command.pagination.CommandPagination;
import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.utils.SoundPlayer;
import com.hm.apache.commons.lang3.math.NumberUtils;
import com.hm.apache.commons.text.StringEscapeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public abstract class AbstractRankingCommand
extends AbstractCommand {
    private static final int CACHE_EXPIRATION_DELAY = 60000;
    private static final int DECIMAL_CIRCLED_ONE = Integer.parseInt("2780", 16);
    private static final int DECIMAL_CIRCLED_ELEVEN = Integer.parseInt("246A", 16);
    private static final int DECIMAL_CIRCLED_TWENTY_ONE = Integer.parseInt("3251", 16);
    private static final int DECIMAL_CIRCLED_THIRTY_SIX = Integer.parseInt("32B1", 16);
    private static final int PER_PAGE = 16;
    private final Logger logger;
    private final String languageKey;
    private final AbstractDatabaseManager databaseManager;
    private final SoundPlayer soundPlayer;
    private ChatColor configColor;
    private int configTopList;
    private boolean configAdditionalEffects;
    private boolean configSound;
    private String configSoundRanking;
    private String langPeriodAchievement;
    private String langPlayerRank;
    private String langNotRanked;
    private Map<String, Integer> cachedSortedRankings;
    private List<Integer> cachedAchievementCounts;
    private long lastCacheUpdate = 0L;

    AbstractRankingCommand(YamlConfiguration yamlConfiguration, YamlConfiguration yamlConfiguration2, StringBuilder stringBuilder, Logger logger, String string, AbstractDatabaseManager abstractDatabaseManager, SoundPlayer soundPlayer) {
        super(yamlConfiguration, yamlConfiguration2, stringBuilder);
        this.logger = logger;
        this.languageKey = string;
        this.databaseManager = abstractDatabaseManager;
        this.soundPlayer = soundPlayer;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.configColor = ChatColor.getByChar((String)this.mainConfig.getString("Color"));
        this.configTopList = this.mainConfig.getInt("TopList");
        this.configAdditionalEffects = this.mainConfig.getBoolean("AdditionalEffects");
        this.configSound = this.mainConfig.getBoolean("Sound");
        this.configSoundRanking = this.mainConfig.getString("SoundRanking").toUpperCase();
        this.langPeriodAchievement = this.pluginHeader + this.langConfig.getString(this.languageKey);
        this.langPlayerRank = this.pluginHeader + this.langConfig.getString("player-rank") + " " + this.configColor;
        this.langNotRanked = this.pluginHeader + this.langConfig.getString("not-ranked");
    }

    @Override
    public void onExecute(CommandSender commandSender, String[] stringArray) {
        if (System.currentTimeMillis() - this.lastCacheUpdate >= 60000L) {
            this.cachedSortedRankings = this.databaseManager.getTopList(this.getRankingStartTime());
            this.cachedAchievementCounts = new ArrayList<Integer>(this.cachedSortedRankings.values());
            this.lastCacheUpdate = System.currentTimeMillis();
        }
        commandSender.sendMessage(this.langPeriodAchievement);
        List<String> list = this.getRankingMessages(commandSender);
        if (this.configTopList < 16) {
            list.forEach(arg_0 -> ((CommandSender)commandSender).sendMessage(arg_0));
        } else {
            int n = this.getPage(stringArray);
            CommandPagination commandPagination = new CommandPagination(list, 16, this.langConfig);
            commandPagination.sendPage(n, commandSender);
        }
        if (commandSender instanceof Player) {
            Integer n = this.cachedSortedRankings.get(((Player)commandSender).getUniqueId().toString());
            if (n == null) {
                commandSender.sendMessage(this.langNotRanked);
            } else {
                int n2 = this.cachedAchievementCounts.indexOf(n) + 1;
                if (n2 <= this.configTopList) {
                    this.launchEffects((Player)commandSender);
                }
                commandSender.sendMessage(this.langPlayerRank + n2 + ChatColor.GRAY + "/" + this.configColor + this.cachedSortedRankings.size());
            }
        }
    }

    private int getPage(String[] stringArray) {
        return stringArray.length > 1 && NumberUtils.isDigits(stringArray[1]) ? Integer.parseInt(stringArray[1]) : 1;
    }

    private List<String> getRankingMessages(CommandSender commandSender) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        for (Map.Entry<String, Integer> entry : this.cachedSortedRankings.entrySet()) {
            String string = Bukkit.getOfflinePlayer((UUID)UUID.fromString(entry.getKey())).getName();
            if (string != null) {
                ChatColor chatColor = string.equals(commandSender.getName()) ? this.configColor : ChatColor.GRAY;
                arrayList.add(chatColor + " " + this.getRankingSymbol(n) + " " + string + " - " + entry.getValue());
            } else {
                this.logger.warning("Ranking command: could not find player's name using a database UUID.");
            }
            if (++n <= this.configTopList) continue;
            break;
        }
        return arrayList;
    }

    private String getRankingSymbol(int n) {
        int n2 = n <= 10 ? DECIMAL_CIRCLED_ONE + n - 1 : (n <= 20 ? DECIMAL_CIRCLED_ELEVEN + n - 11 : (n <= 35 ? DECIMAL_CIRCLED_TWENTY_ONE + n - 21 : DECIMAL_CIRCLED_THIRTY_SIX + n - 36));
        return StringEscapeUtils.unescapeJava("\\u" + Integer.toHexString(n2));
    }

    abstract long getRankingStartTime();

    private void launchEffects(Player player) {
        if (this.configAdditionalEffects) {
            player.spawnParticle(Particle.PORTAL, player.getLocation(), 100, 0.0, 1.0, 0.0, 0.5);
        }
        if (this.configSound) {
            this.soundPlayer.play(player, this.configSoundRanking, "ENTITY_FIREWORK_ROCKET_BLAST");
        }
    }
}

