/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executable;

import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.command.executable.AbstractParsableCommand;
import com.hm.achievement.command.executable.CommandSpec;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.utils.StatisticIncreaseHandler;
import com.hm.achievement.utils.StringHelper;
import com.hm.apache.commons.lang3.StringUtils;
import com.hm.apache.commons.lang3.math.NumberUtils;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

@Singleton
@CommandSpec(name="add", permission="add", minArgs=4, maxArgs=4)
public class AddCommand
extends AbstractParsableCommand {
    private static final long MILLIS_PER_HOUR = TimeUnit.HOURS.toMillis(1L);
    private final AbstractDatabaseManager databaseManager;
    private final CacheManager cacheManager;
    private final StatisticIncreaseHandler statisticIncreaseHandler;
    private String langErrorValue;
    private String langStatisticIncreased;
    private String langCategoryDoesNotExist;
    private final AchievementMap achievementMap;

    @Inject
    public AddCommand(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, StringBuilder stringBuilder, AbstractDatabaseManager abstractDatabaseManager, CacheManager cacheManager, StatisticIncreaseHandler statisticIncreaseHandler, AchievementMap achievementMap) {
        super(yamlConfiguration, yamlConfiguration2, stringBuilder);
        this.databaseManager = abstractDatabaseManager;
        this.cacheManager = cacheManager;
        this.statisticIncreaseHandler = statisticIncreaseHandler;
        this.achievementMap = achievementMap;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.langErrorValue = this.pluginHeader + this.langConfig.getString("error-value");
        this.langStatisticIncreased = this.pluginHeader + this.langConfig.getString("statistic-increased");
        this.langCategoryDoesNotExist = this.pluginHeader + this.langConfig.getString("category-does-not-exist");
    }

    @Override
    void onExecuteForPlayer(CommandSender commandSender, String[] stringArray, Player player) {
        if (!NumberUtils.isCreatable(stringArray[1])) {
            commandSender.sendMessage(StringUtils.replaceOnce(this.langErrorValue, "VALUE", stringArray[1]));
            return;
        }
        int n = Integer.parseInt(stringArray[1]);
        Set<String> set = this.achievementMap.getCategorySubcategories();
        if (set.contains(stringArray[2])) {
            UUID uUID = player.getUniqueId();
            if (stringArray[2].contains(".")) {
                MultipleAchievements multipleAchievements = MultipleAchievements.getByName(StringUtils.substringBefore(stringArray[2], "."));
                String string = StringUtils.substringAfter(stringArray[2], ".");
                long l = this.cacheManager.getAndIncrementStatisticAmount(multipleAchievements, string, uUID, n);
                this.statisticIncreaseHandler.checkThresholdsAndAchievements(player, multipleAchievements, string, l);
            } else {
                long l;
                NormalAchievements normalAchievements = NormalAchievements.getByName(stringArray[2]);
                if (normalAchievements == NormalAchievements.PLAYEDTIME) {
                    n = (int)((long)n * MILLIS_PER_HOUR);
                    l = this.cacheManager.getAndIncrementStatisticAmount(normalAchievements, uUID, n) / MILLIS_PER_HOUR;
                } else if (normalAchievements == NormalAchievements.CONNECTIONS) {
                    l = this.databaseManager.getNormalAchievementAmount(uUID, NormalAchievements.CONNECTIONS) + (long)n;
                    this.databaseManager.updateConnectionInformation(uUID, l);
                } else {
                    l = this.cacheManager.getAndIncrementStatisticAmount(normalAchievements, uUID, n);
                }
                this.statisticIncreaseHandler.checkThresholdsAndAchievements(player, normalAchievements, l);
            }
            commandSender.sendMessage(StringUtils.replaceEach(this.langStatisticIncreased, new String[]{"ACH", "AMOUNT", "PLAYER"}, new String[]{stringArray[2], stringArray[1], stringArray[3]}));
        } else {
            commandSender.sendMessage(StringUtils.replaceEach(this.langCategoryDoesNotExist, new String[]{"CAT", "CLOSEST_MATCH"}, new String[]{stringArray[2], StringHelper.getClosestMatch(stringArray[2], set)}));
        }
    }
}

