/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executable;

import com.hm.achievement.command.executable.AbstractCommand;
import com.hm.achievement.command.executable.CommandSpec;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.db.data.AwardedDBAchievement;
import com.hm.achievement.domain.Achievement;
import com.hm.achievement.lifecycle.Cleanable;
import com.hm.achievement.utils.SoundPlayer;
import com.hm.apache.commons.lang3.StringUtils;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

@Singleton
@CommandSpec(name="book", permission="book", minArgs=1, maxArgs=1)
public class BookCommand
extends AbstractCommand
implements Cleanable {
    private static final String PACKAGE_INVENTORY = "inventory";
    private static final String PACKAGE_UTIL = "util";
    private static final String CLASS_CRAFT_META_BOOK = "CraftMetaBook";
    private static final String CLASS_CRAFT_CHAT_MESSAGE = "CraftChatMessage";
    private static final String FIELD_PAGES = "pages";
    private static final String METHOD_FROM_STRING = "fromString";
    private final HashMap<UUID, Long> playersBookTime = new HashMap();
    private final Logger logger;
    private final int serverVersion;
    private final AbstractDatabaseManager databaseManager;
    private final SoundPlayer soundPlayer;
    private final AchievementMap achievementMap;
    private int configTimeBook;
    private String configBookSeparator;
    private boolean configAdditionalEffects;
    private boolean configSound;
    private String configSoundBook;
    private String langBookDelay;
    private String langBookNotReceived;
    private String langBookDate;
    private String langBookName;
    private String langBookReceived;
    private DateFormat dateFormat;

    @Inject
    public BookCommand(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, StringBuilder stringBuilder, Logger logger, int n, AbstractDatabaseManager abstractDatabaseManager, SoundPlayer soundPlayer, AchievementMap achievementMap) {
        super(yamlConfiguration, yamlConfiguration2, stringBuilder);
        this.logger = logger;
        this.serverVersion = n;
        this.databaseManager = abstractDatabaseManager;
        this.soundPlayer = soundPlayer;
        this.achievementMap = achievementMap;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.configTimeBook = this.mainConfig.getInt("TimeBook") * 1000;
        this.configBookSeparator = "\n&r" + this.mainConfig.getString("BookSeparator") + "\n&r";
        this.configAdditionalEffects = this.mainConfig.getBoolean("AdditionalEffects");
        this.configSound = this.mainConfig.getBoolean("Sound");
        this.configSoundBook = this.mainConfig.getString("SoundBook").toUpperCase();
        this.langBookDelay = this.pluginHeader + StringUtils.replaceOnce(this.langConfig.getString("book-delay"), "TIME", Integer.toString(this.configTimeBook / 1000));
        this.langBookNotReceived = this.pluginHeader + this.langConfig.getString("book-not-received");
        this.langBookDate = this.translateColorCodes("&8" + this.langConfig.getString("book-date"));
        this.langBookName = this.langConfig.getString("book-name");
        this.langBookReceived = this.pluginHeader + this.langConfig.getString("book-received");
        String string = this.mainConfig.getString("DateLocale");
        this.dateFormat = DateFormat.getDateInstance(2, new Locale(string));
    }

    @Override
    public void cleanPlayerData() {
        long l = System.currentTimeMillis();
        this.playersBookTime.values().removeIf(l2 -> l > l2 + (long)this.configTimeBook);
    }

    @Override
    void onExecute(CommandSender commandSender, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            return;
        }
        Player player = (Player)commandSender;
        if (!this.isInCooldownPeriod(player)) {
            List<AwardedDBAchievement> list = this.databaseManager.getPlayerAchievementsList(player.getUniqueId());
            if (list.isEmpty()) {
                player.sendMessage(this.langBookNotReceived);
                return;
            }
            if (this.configAdditionalEffects) {
                player.spawnParticle(Particle.ENCHANTMENT_TABLE, player.getLocation(), 1000, 0.0, 2.0, 0.0, 1.0);
            }
            if (this.configSound) {
                this.soundPlayer.play(player, this.configSoundBook, "ENTITY_PLAYER_LEVELUP");
            }
            this.fillBook(list, player);
        } else {
            player.sendMessage(this.langBookDelay);
        }
    }

    private void fillBook(List<AwardedDBAchievement> list, Player player) {
        ItemStack itemStack = new ItemStack(Material.WRITTEN_BOOK);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        BookMeta bookMeta = (BookMeta)itemStack.getItemMeta();
        for (AwardedDBAchievement awardedDBAchievement : list) {
            Achievement achievement = this.achievementMap.getForName(awardedDBAchievement.getName());
            if (achievement == null) continue;
            String string = "&0" + achievement.getDisplayName() + this.configBookSeparator + achievement.getMessage() + this.configBookSeparator + awardedDBAchievement.getFormattedDate();
            string = this.translateColorCodes(string);
            arrayList.add(string);
        }
        this.setBookPages(arrayList, bookMeta);
        bookMeta.setAuthor(player.getName());
        bookMeta.setTitle(this.langBookName);
        bookMeta.setLore(Arrays.asList(StringUtils.replaceOnce(this.langBookDate, "DATE", this.dateFormat.format(System.currentTimeMillis()))));
        itemStack.setItemMeta((ItemMeta)bookMeta);
        if (player.getInventory().firstEmpty() != -1) {
            player.getInventory().addItem(new ItemStack[]{itemStack});
        } else {
            player.getWorld().dropItem(player.getLocation(), itemStack);
        }
        player.sendMessage(this.langBookReceived);
    }

    private boolean isInCooldownPeriod(Player player) {
        if (player.hasPermission("achievement.*") || this.configTimeBook == 0) {
            return false;
        }
        long l = System.currentTimeMillis();
        Long l2 = this.playersBookTime.get(player.getUniqueId());
        if (l2 == null || l - l2 > (long)this.configTimeBook) {
            this.playersBookTime.put(player.getUniqueId(), l);
            return false;
        }
        return true;
    }

    private void setBookPages(List<String> list, BookMeta bookMeta) {
        if (this.serverVersion <= 15) {
            try {
                String string = Bukkit.getServer().getClass().getPackage().getName().substring(23);
                Class<?> clazz = Class.forName("org.bukkit.craftbukkit." + string + "." + PACKAGE_INVENTORY + "." + CLASS_CRAFT_META_BOOK);
                List list2 = (List)clazz.getField(FIELD_PAGES).get(clazz.cast(bookMeta));
                Method method = Class.forName("org.bukkit.craftbukkit." + string + "." + PACKAGE_UTIL + "." + CLASS_CRAFT_CHAT_MESSAGE).getMethod(METHOD_FROM_STRING, String.class, Boolean.TYPE);
                for (String string2 : list) {
                    list2.add(((Object[])method.invoke(null, string2, true))[0]);
                }
            }
            catch (Exception exception) {
                this.logger.warning("Error while creating book pages. Your achievements book may be trimmed down to 50 pages.");
                bookMeta.setPages(list);
            }
        } else {
            bookMeta.setPages(list);
        }
    }
}

