/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executable;

import com.hm.achievement.command.executable.AbstractParsableCommand;
import com.hm.achievement.command.executable.CommandSpec;
import com.hm.achievement.db.CacheManager;
import com.hm.apache.commons.lang3.StringUtils;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

@Singleton
@CommandSpec(name="check", permission="check", minArgs=3, maxArgs=0x7FFFFFFF)
public class CheckCommand
extends AbstractParsableCommand {
    private final CacheManager cacheManager;
    private String langCheckAchievementTrue;
    private String langCheckAchievementFalse;

    @Inject
    public CheckCommand(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, StringBuilder stringBuilder, CacheManager cacheManager) {
        super(yamlConfiguration, yamlConfiguration2, stringBuilder);
        this.cacheManager = cacheManager;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.langCheckAchievementTrue = this.pluginHeader + this.langConfig.getString("check-achievement-true");
        this.langCheckAchievementFalse = this.pluginHeader + this.langConfig.getString("check-achievements-false");
    }

    @Override
    void onExecuteForPlayer(CommandSender commandSender, String[] stringArray, Player player) {
        String string = this.parseAchievementName(stringArray);
        if (this.cacheManager.hasPlayerAchievement(player.getUniqueId(), string)) {
            commandSender.sendMessage(StringUtils.replaceEach(this.langCheckAchievementTrue, new String[]{"PLAYER", "ACH"}, new String[]{stringArray[stringArray.length - 1], string}));
        } else {
            commandSender.sendMessage(StringUtils.replaceEach(this.langCheckAchievementFalse, new String[]{"PLAYER", "ACH"}, new String[]{stringArray[stringArray.length - 1], string}));
        }
    }
}

