/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executable;

import com.hm.achievement.command.executable.AbstractParsableCommand;
import com.hm.achievement.command.executable.CommandSpec;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.db.CacheManager;
import com.hm.apache.commons.lang3.StringUtils;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

@Singleton
@CommandSpec(name="delete", permission="delete", minArgs=3, maxArgs=0x7FFFFFFF)
public class DeleteCommand
extends AbstractParsableCommand {
    public static final String WILDCARD = "*";
    private final CacheManager cacheManager;
    private final AbstractDatabaseManager databaseManager;
    private final AchievementMap achievementMap;
    private String langCheckAchievementFalse;
    private String langDeleteAchievements;
    private String langAllDeleteAchievements;

    @Inject
    public DeleteCommand(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, StringBuilder stringBuilder, CacheManager cacheManager, AbstractDatabaseManager abstractDatabaseManager, AchievementMap achievementMap) {
        super(yamlConfiguration, yamlConfiguration2, stringBuilder);
        this.cacheManager = cacheManager;
        this.databaseManager = abstractDatabaseManager;
        this.achievementMap = achievementMap;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.langCheckAchievementFalse = this.pluginHeader + this.langConfig.getString("check-achievements-false");
        this.langDeleteAchievements = this.pluginHeader + this.langConfig.getString("delete-achievements");
        this.langAllDeleteAchievements = this.pluginHeader + this.langConfig.getString("delete-all-achievements");
    }

    @Override
    void onExecuteForPlayer(CommandSender commandSender, String[] stringArray, Player player) {
        String string = this.parseAchievementName(stringArray);
        if (WILDCARD.equals(string)) {
            this.cacheManager.removePreviouslyReceivedAchievements(player.getUniqueId(), this.achievementMap.getAllNames());
            this.databaseManager.deleteAllPlayerAchievements(player.getUniqueId());
            commandSender.sendMessage(StringUtils.replace(this.langAllDeleteAchievements, "PLAYER", stringArray[stringArray.length - 1]));
        } else if (this.cacheManager.hasPlayerAchievement(player.getUniqueId(), string)) {
            this.cacheManager.removePreviouslyReceivedAchievements(player.getUniqueId(), Collections.singletonList(string));
            this.databaseManager.deletePlayerAchievement(player.getUniqueId(), string);
            commandSender.sendMessage(StringUtils.replaceEach(this.langDeleteAchievements, new String[]{"PLAYER", "ACH"}, new String[]{stringArray[stringArray.length - 1], string}));
        } else {
            commandSender.sendMessage(StringUtils.replaceEach(this.langCheckAchievementFalse, new String[]{"PLAYER", "ACH"}, new String[]{stringArray[stringArray.length - 1], string}));
        }
    }
}

