/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executable;

import com.hm.achievement.category.CommandAchievements;
import com.hm.achievement.command.executable.AbstractParsableCommand;
import com.hm.achievement.command.executable.CommandSpec;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.domain.Achievement;
import com.hm.achievement.utils.PlayerAdvancedAchievementEvent;
import com.hm.achievement.utils.StringHelper;
import com.hm.apache.commons.lang3.StringUtils;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Singleton
@CommandSpec(name="give", permission="give", minArgs=3, maxArgs=3)
public class GiveCommand
extends AbstractParsableCommand {
    private final CacheManager cacheManager;
    private final AchievementMap achievementMap;
    private boolean configMultiCommand;
    private String langAchievementAlreadyReceived;
    private String langAchievementGiven;
    private String langAchievementNotFound;
    private String langAchievementNoPermission;

    @Inject
    public GiveCommand(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, StringBuilder stringBuilder, CacheManager cacheManager, AchievementMap achievementMap) {
        super(yamlConfiguration, yamlConfiguration2, stringBuilder);
        this.cacheManager = cacheManager;
        this.achievementMap = achievementMap;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.configMultiCommand = this.mainConfig.getBoolean("MultiCommand");
        this.langAchievementAlreadyReceived = this.pluginHeader + this.langConfig.getString("achievement-already-received");
        this.langAchievementGiven = this.pluginHeader + this.langConfig.getString("achievement-given");
        this.langAchievementNotFound = this.pluginHeader + this.langConfig.getString("achievement-not-found");
        this.langAchievementNoPermission = this.pluginHeader + this.langConfig.getString("achievement-no-permission");
    }

    @Override
    void onExecuteForPlayer(CommandSender commandSender, String[] stringArray, Player player) {
        Optional<Achievement> optional = this.achievementMap.getForCategory(CommandAchievements.COMMANDS).stream().filter(achievement -> achievement.getSubcategory().equals(stringArray[1])).findAny();
        if (optional.isPresent()) {
            if (!this.configMultiCommand && this.cacheManager.hasPlayerAchievement(player.getUniqueId(), optional.get().getName())) {
                commandSender.sendMessage(StringUtils.replaceOnce(this.langAchievementAlreadyReceived, "PLAYER", stringArray[2]));
                return;
            }
            if (!player.hasPermission("achievement." + optional.get().getName())) {
                commandSender.sendMessage(StringUtils.replaceOnce(this.langAchievementNoPermission, "PLAYER", stringArray[2]));
                return;
            }
            Bukkit.getPluginManager().callEvent((Event)new PlayerAdvancedAchievementEvent(player, optional.get()));
            commandSender.sendMessage(this.langAchievementGiven);
        } else {
            Set<String> set = this.achievementMap.getSubcategoriesForCategory(CommandAchievements.COMMANDS);
            commandSender.sendMessage(StringUtils.replaceOnce(this.langAchievementNotFound, "CLOSEST_MATCH", StringHelper.getClosestMatch(stringArray[1], set)));
        }
    }
}

