/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executable;

import com.hm.achievement.command.executable.AbstractCommand;
import com.hm.achievement.command.executable.CommandSpec;
import com.hm.achievement.utils.FancyMessageSender;
import com.hm.apache.commons.lang3.StringUtils;
import com.hm.apache.commons.text.StringEscapeUtils;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

@Singleton
@CommandSpec(name="help", permission="", minArgs=0, maxArgs=0x7FFFFFFF)
public class HelpCommand
extends AbstractCommand {
    private final FancyMessageSender fancyMessageSender;
    private ChatColor configColor;
    private String configIcon;
    private String langCommandList;
    private String langCommandListHover;
    private String langCommandTop;
    private String langCommandTopHover;
    private String langCommandInfo;
    private String langCommandInfoHover;
    private String langCommandBook;
    private String langCommandBookHover;
    private String langCommandWeek;
    private String langCommandWeekHover;
    private String langCommandStats;
    private String langCommandStatsHover;
    private String langCommandMonth;
    private String langCommandMonthHover;
    private String langCommandToggleHover;
    private String langCommandToggle;
    private String langCommandReload;
    private String langCommandReloadHover;
    private String langCommandGenerate;
    private String langCommandGenerateHover;
    private String langCommandInspect;
    private String langCommandInspectHover;
    private String langCommandGive;
    private String langCommandGiveHover;
    private String langCommandAdd;
    private String langCommandAddHover;
    private String langCommandReset;
    private String langCommandResetHover;
    private String langCommandCheck;
    private String langCommandCheckHover;
    private String langCommandDelete;
    private String langCommandDeleteHover;
    private String langTip;

    @Inject
    public HelpCommand(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, StringBuilder stringBuilder, FancyMessageSender fancyMessageSender) {
        super(yamlConfiguration, yamlConfiguration2, stringBuilder);
        this.fancyMessageSender = fancyMessageSender;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.configColor = ChatColor.getByChar((String)this.mainConfig.getString("Color"));
        this.configIcon = StringEscapeUtils.unescapeJava(this.mainConfig.getString("Icon"));
        this.langCommandList = this.header("/aach list") + this.langConfig.getString("aach-command-list");
        this.langCommandListHover = this.langConfig.getString("aach-command-list-hover");
        this.langCommandTop = this.header("/aach top") + this.langConfig.getString("aach-command-top");
        this.langCommandTopHover = this.langConfig.getString("aach-command-top-hover");
        this.langCommandInfo = this.header("/aach info") + this.langConfig.getString("aach-command-info");
        this.langCommandInfoHover = this.langConfig.getString("aach-command-info-hover");
        this.langCommandBook = this.header("/aach book") + this.langConfig.getString("aach-command-book");
        this.langCommandBookHover = this.langConfig.getString("aach-command-book-hover");
        this.langCommandWeek = this.header("/aach week") + this.langConfig.getString("aach-command-week");
        this.langCommandWeekHover = this.langConfig.getString("aach-command-week-hover");
        this.langCommandStats = this.header("/aach stats") + this.langConfig.getString("aach-command-stats");
        this.langCommandStatsHover = this.langConfig.getString("aach-command-stats-hover");
        this.langCommandMonth = this.header("/aach month") + this.langConfig.getString("aach-command-month");
        this.langCommandMonthHover = this.langConfig.getString("aach-command-month-hover");
        this.langCommandToggle = this.header("/aach toggle") + this.langConfig.getString("aach-command-toggle");
        this.langCommandToggleHover = this.langConfig.getString("aach-command-toggle-hover");
        this.langCommandReload = this.header("/aach reload") + this.langConfig.getString("aach-command-reload");
        this.langCommandReloadHover = this.langConfig.getString("aach-command-reload-hover");
        this.langCommandGenerate = this.header("/aach generate") + this.langConfig.getString("aach-command-generate");
        this.langCommandGenerateHover = this.langConfig.getString("aach-command-generate-hover");
        this.langCommandGive = this.header("/aach give &oach player") + this.translateColorCodes(StringUtils.replaceEach(this.langConfig.getString("aach-command-give"), new String[]{"ACH", "NAME"}, new String[]{"&oach&7", "&oplayer&7"}));
        this.langCommandInspect = this.header("/aach inspect &oach") + this.translateColorCodes(StringUtils.replaceOnce(this.langConfig.getString("aach-command-inspect"), "ACH", "&oach&7"));
        this.langCommandInspectHover = this.langConfig.getString("aach-command-inspect-hover");
        this.langCommandGiveHover = this.langConfig.getString("aach-command-give-hover");
        this.langCommandAdd = this.header("/aach add &ox cat player") + this.langConfig.getString("aach-command-add");
        this.langCommandAddHover = this.langConfig.getString("aach-command-add-hover");
        this.langCommandReset = this.header("/aach reset &ocat player") + StringUtils.replaceOnce(this.langConfig.getString("aach-command-reset"), "CAT", "&ocat&7");
        this.langCommandResetHover = this.langConfig.getString("aach-command-reset-hover");
        this.langCommandCheck = this.header("/aach check &oach player") + this.translateColorCodes(StringUtils.replaceEach(this.langConfig.getString("aach-command-check"), new String[]{"ACH", "NAME"}, new String[]{"&oach&7", "&oplayer&7"}));
        this.langCommandCheckHover = this.langConfig.getString("aach-command-check-hover");
        this.langCommandDelete = this.header("/aach delete &oach player") + this.translateColorCodes(StringUtils.replaceEach(this.langConfig.getString("aach-command-delete"), new String[]{"ACH", "NAME"}, new String[]{"&oach&7", "&oplayer&7"}));
        this.langCommandDeleteHover = this.langConfig.getString("aach-command-delete-hover");
        this.langTip = ChatColor.GRAY + this.translateColorCodes(this.langConfig.getString("aach-tip"));
    }

    private String header(String string) {
        return this.pluginHeader.toString() + this.configColor + string + ChatColor.GRAY + " > ";
    }

    @Override
    void onExecute(CommandSender commandSender, String[] stringArray) {
        commandSender.sendMessage(this.configColor + "------------ " + this.configIcon + this.translateColorCodes(" &lAdvanced Achievements ") + this.configColor + this.configIcon + this.configColor + " ------------");
        if (commandSender.hasPermission("achievement.list")) {
            this.sendJsonClickableHoverableMessage(commandSender, this.langCommandList, "/aach list", this.langCommandListHover);
        }
        if (commandSender.hasPermission("achievement.top")) {
            this.sendJsonClickableHoverableMessage(commandSender, this.langCommandTop, "/aach top", this.langCommandTopHover);
        }
        this.sendJsonClickableHoverableMessage(commandSender, this.langCommandInfo, "/aach info", this.langCommandInfoHover);
        if (commandSender.hasPermission("achievement.book")) {
            this.sendJsonClickableHoverableMessage(commandSender, this.langCommandBook, "/aach book", this.langCommandBookHover);
        }
        if (commandSender.hasPermission("achievement.week")) {
            this.sendJsonClickableHoverableMessage(commandSender, this.langCommandWeek, "/aach week", this.langCommandWeekHover);
        }
        if (commandSender.hasPermission("achievement.stats")) {
            this.sendJsonClickableHoverableMessage(commandSender, this.langCommandStats, "/aach stats", this.langCommandStatsHover);
        }
        if (commandSender.hasPermission("achievement.month")) {
            this.sendJsonClickableHoverableMessage(commandSender, this.langCommandMonth, "/aach month", this.langCommandMonthHover);
        }
        if (commandSender.hasPermission("achievement.toggle")) {
            this.sendJsonClickableHoverableMessage(commandSender, this.langCommandToggle, "/aach toggle", this.langCommandToggleHover);
        }
        if (commandSender.hasPermission("achievement.reload")) {
            this.sendJsonClickableHoverableMessage(commandSender, this.langCommandReload, "/aach reload", this.langCommandReloadHover);
        }
        if (commandSender.hasPermission("achievement.generate")) {
            this.sendJsonClickableHoverableMessage(commandSender, this.langCommandGenerate, "/aach generate", this.langCommandGenerateHover);
        }
        if (commandSender.hasPermission("achievement.inspect")) {
            this.sendJsonClickableHoverableMessage(commandSender, this.langCommandInspect, "/aach inspect ach", this.langCommandInspectHover);
        }
        if (commandSender.hasPermission("achievement.give")) {
            this.sendJsonClickableHoverableMessage(commandSender, this.langCommandGive, "/aach give ach name", this.langCommandGiveHover);
        }
        if (commandSender.hasPermission("achievement.add")) {
            this.sendJsonClickableHoverableMessage(commandSender, this.langCommandAdd, "/aach add x cat name", this.langCommandAddHover);
        }
        if (commandSender.hasPermission("achievement.reset")) {
            this.sendJsonClickableHoverableMessage(commandSender, this.langCommandReset, "/aach reset cat name", this.langCommandResetHover);
        }
        if (commandSender.hasPermission("achievement.check")) {
            this.sendJsonClickableHoverableMessage(commandSender, this.langCommandCheck, "/aach check ach name", this.langCommandCheckHover);
        }
        if (commandSender.hasPermission("achievement.delete")) {
            this.sendJsonClickableHoverableMessage(commandSender, this.langCommandDelete, "/aach delete ach name", this.langCommandDeleteHover);
        }
        commandSender.sendMessage(this.configColor + " ");
        commandSender.sendMessage(this.langTip);
    }

    private void sendJsonClickableHoverableMessage(CommandSender commandSender, String string, String string2, String string3) {
        if (commandSender instanceof Player) {
            this.fancyMessageSender.sendHoverableCommandMessage((Player)commandSender, string, string2, string3, this.configColor.name().toLowerCase());
        } else {
            commandSender.sendMessage(string);
        }
    }
}

