/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executable;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.command.executable.AbstractCommand;
import com.hm.achievement.command.executable.CommandSpec;
import com.hm.achievement.command.pagination.SupplierCommandPagination;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.db.data.AwardedDBAchievement;
import com.hm.achievement.domain.Achievement;
import com.hm.achievement.utils.StringHelper;
import com.hm.apache.commons.lang3.StringUtils;
import com.hm.apache.commons.lang3.math.NumberUtils;
import com.hm.apache.commons.text.TextStringBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

@Singleton
@CommandSpec(name="inspect", permission="inspect", minArgs=1, maxArgs=0x7FFFFFFF)
public class InspectCommand
extends AbstractCommand {
    private static final int CACHE_EXPIRATION_DELAY = 60000;
    private static final int PER_PAGE = 16;
    private final AdvancedAchievements advancedAchievements;
    private final AbstractDatabaseManager databaseManager;
    private final AchievementMap achievementMap;
    private final Map<String, Long> lastCached;
    private final Map<String, SupplierCommandPagination> cachedPaginations;

    @Inject
    public InspectCommand(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, StringBuilder stringBuilder, AdvancedAchievements advancedAchievements, AbstractDatabaseManager abstractDatabaseManager, AchievementMap achievementMap) {
        super(yamlConfiguration, yamlConfiguration2, stringBuilder);
        this.advancedAchievements = advancedAchievements;
        this.databaseManager = abstractDatabaseManager;
        this.achievementMap = achievementMap;
        this.lastCached = new HashMap<String, Long>();
        this.cachedPaginations = new HashMap<String, SupplierCommandPagination>();
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
    }

    private int getPage(String[] stringArray) {
        boolean bl = stringArray.length > 1 && NumberUtils.isDigits(stringArray[stringArray.length - 1]);
        return bl ? Integer.parseInt(stringArray[stringArray.length - 1]) : 1;
    }

    @Override
    void onExecute(CommandSender commandSender, String[] stringArray) {
        String string = this.parseAchievementName(stringArray);
        Achievement achievement = this.getAchievement(string);
        if (achievement == null) {
            commandSender.sendMessage(this.pluginHeader + StringUtils.replaceEach(this.langConfig.getString("achievement_not_recognized"), new String[]{"NAME", "CLOSEST_MATCH"}, new String[]{string, StringHelper.getClosestMatch(string, this.achievementMap.getAllSanitisedDisplayNames())}));
            return;
        }
        int n = this.getPage(stringArray);
        this.advancedAchievements.getServer().getScheduler().runTaskAsynchronously((Plugin)this.advancedAchievements, () -> {
            this.cleanUpCache();
            this.checkAndCache(achievement.getName());
            SupplierCommandPagination supplierCommandPagination = this.cachedPaginations.get(achievement.getName());
            supplierCommandPagination.sendPage(n, commandSender);
        });
    }

    private String parseAchievementName(String[] stringArray) {
        boolean bl;
        TextStringBuilder textStringBuilder = new TextStringBuilder();
        boolean bl2 = bl = stringArray.length > 1 && NumberUtils.isDigits(stringArray[stringArray.length - 1]);
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray).subList(1, stringArray.length - 1));
            textStringBuilder.appendWithSeparators(arrayList, " ");
        } else {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray).subList(1, stringArray.length));
            textStringBuilder.appendWithSeparators(arrayList, " ");
        }
        return textStringBuilder.toString();
    }

    private Achievement getAchievement(String string) {
        Achievement achievement = this.achievementMap.getForDisplayName(string);
        if (achievement == null) {
            achievement = this.achievementMap.getForDisplayName(string.replace(' ', '_'));
        }
        return achievement;
    }

    private void cleanUpCache() {
        long l = System.currentTimeMillis();
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, Long> entry : this.lastCached.entrySet()) {
            if (l - 60000L <= entry.getValue()) continue;
            hashSet.add(entry.getKey());
        }
        for (String string : hashSet) {
            this.cachedPaginations.remove(string);
            this.lastCached.remove(string);
        }
    }

    private void checkAndCache(String string) {
        if (System.currentTimeMillis() - 60000L > this.lastCached.getOrDefault(string, 0L)) {
            List<AwardedDBAchievement> list = this.databaseManager.getAchievementsRecipientList(string);
            List<Supplier<String>> list2 = list.stream().map(awardedDBAchievement -> () -> {
                UUID uUID = awardedDBAchievement.getAwardedTo();
                OfflinePlayer offlinePlayer = this.advancedAchievements.getServer().getOfflinePlayer(uUID);
                String string = offlinePlayer.hasPlayedBefore() ? offlinePlayer.getName() : uUID.toString();
                return "  " + string + " (" + awardedDBAchievement.getFormattedDate() + ")";
            }).collect(Collectors.toList());
            SupplierCommandPagination supplierCommandPagination = new SupplierCommandPagination(list2, 16, this.langConfig);
            this.cachedPaginations.put(string, supplierCommandPagination);
            this.lastCached.put(string, System.currentTimeMillis());
        }
    }
}

