/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executable;

import com.hm.achievement.command.executable.AbstractCommand;
import com.hm.achievement.command.executable.CommandSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

@Singleton
@CommandSpec(name="toggle", permission="toggle", minArgs=1, maxArgs=2)
public class ToggleCommand
extends AbstractCommand {
    private final Set<UUID> toggledPlayers = new HashSet<UUID>();
    private final Map<String, Set<UUID>> typesToToggledPlayers = new HashMap<String, Set<UUID>>();
    private boolean configNotifyOtherPlayers;
    private String langToggleDisplayed;
    private String langToggleHidden;

    @Inject
    public ToggleCommand(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, StringBuilder stringBuilder) {
        super(yamlConfiguration, yamlConfiguration2, stringBuilder);
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.configNotifyOtherPlayers = this.mainConfig.getBoolean("NotifyOtherPlayers");
        this.langToggleDisplayed = this.pluginHeader + this.langConfig.getString("toggle-displayed");
        this.langToggleHidden = this.pluginHeader + this.langConfig.getString("toggle-hidden");
    }

    public boolean isPlayerToggled(Player player, String string) {
        return this.toggledPlayers.contains(player.getUniqueId()) || this.typesToToggledPlayers.getOrDefault(string, Collections.emptySet()).contains(player.getUniqueId());
    }

    @Override
    void onExecute(CommandSender commandSender, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            return;
        }
        Player player = (Player)commandSender;
        Set set = this.toggledPlayers;
        if (stringArray.length > 1) {
            set = this.typesToToggledPlayers.computeIfAbsent(stringArray[1], string -> new HashSet());
        }
        if (set.contains(player.getUniqueId())) {
            set.remove(player.getUniqueId());
            this.displayChatMessage(player, this.configNotifyOtherPlayers);
        } else {
            set.add(player.getUniqueId());
            this.displayChatMessage(player, !this.configNotifyOtherPlayers);
        }
    }

    private void displayChatMessage(Player player, boolean bl) {
        if (bl) {
            player.sendMessage(this.langToggleDisplayed);
        } else {
            player.sendMessage(this.langToggleHidden);
        }
    }
}

