/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.external;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Team;

public class CommandUtils {
    public static Entity[] getTargets(CommandSender commandSender, String string) {
        Entity[] entityArray;
        int n;
        Location location = null;
        if (commandSender instanceof Player) {
            location = ((Player)commandSender).getLocation();
        } else if (commandSender instanceof BlockCommandSender) {
            location = ((BlockCommandSender)commandSender).getBlock().getLocation().add(0.5, 0.0, 0.5);
        } else if (commandSender instanceof CommandMinecart) {
            location = ((CommandMinecart)commandSender).getLocation();
        }
        String[] stringArray = CommandUtils.getTags(string);
        Object object2 = stringArray;
        int n2 = ((String[])object2).length;
        for (n = 0; n < n2; ++n) {
            String object3 = object2[n];
            if (CommandUtils.hasTag(SelectorType.X, object3)) {
                location.setX((double)CommandUtils.getInt(object3));
                continue;
            }
            if (CommandUtils.hasTag(SelectorType.Y, object3)) {
                location.setY((double)CommandUtils.getInt(object3));
                continue;
            }
            if (!CommandUtils.hasTag(SelectorType.Z, object3)) continue;
            location.setZ((double)CommandUtils.getInt(object3));
        }
        if (string.startsWith("@s")) {
            Entity[] entityArray2 = new Entity[1];
            if (commandSender instanceof Player) {
                boolean bl = true;
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    if (CommandUtils.canBeAccepted(stringArray[n2], (Entity)commandSender, location)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    entityArray2[0] = (Entity)commandSender;
                }
            } else {
                return null;
            }
            return entityArray2;
        }
        if (string.startsWith("@a")) {
            object2 = new ArrayList();
            n2 = CommandUtils.getLimit(string);
            n = 1;
            for (String string2 : stringArray) {
                if (!CommandUtils.hasTag(SelectorType.TYPE, string2)) continue;
                n = 0;
                break;
            }
            ArrayList arrayList = new ArrayList(Bukkit.getOnlinePlayers());
            if (n == 0) {
                arrayList.clear();
                for (World world : CommandUtils.getAcceptedWorldsFullString(location, string)) {
                    arrayList.addAll(world.getEntities());
                }
            }
            for (Entity entity : arrayList) {
                if (object2.size() >= n2) break;
                boolean bl = true;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (CommandUtils.canBeAccepted(stringArray[i], entity, location)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                object2.add(entity);
            }
            entityArray = object2.toArray(new Entity[object2.size()]);
        } else if (string.startsWith("@p")) {
            entityArray = new Entity[1];
            double d = Double.MAX_VALUE;
            Player player = null;
            for (World world : CommandUtils.getAcceptedWorldsFullString(location, string)) {
                for (Player player2 : world.getPlayers()) {
                    double d2;
                    if (player2 == commandSender) continue;
                    Location location2 = location;
                    if (location2 == null) {
                        location2 = player2.getWorld().getSpawnLocation();
                    }
                    if (!(d > (d2 = player2.getLocation().distanceSquared(location2)))) continue;
                    boolean bl = true;
                    for (String string3 : stringArray) {
                        if (CommandUtils.canBeAccepted(string3, (Entity)player2, location2)) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    d = d2;
                    player = player2;
                }
            }
            entityArray[0] = player;
        } else if (string.startsWith("@e")) {
            object2 = new ArrayList();
            n2 = CommandUtils.getLimit(string);
            block9: for (World world : CommandUtils.getAcceptedWorldsFullString(location, string)) {
                for (Entity entity : world.getEntities()) {
                    if (object2.size() > n2) continue block9;
                    if (entity == commandSender) continue;
                    boolean bl = true;
                    for (String string4 : stringArray) {
                        if (CommandUtils.canBeAccepted(string4, entity, location)) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    object2.add(entity);
                }
            }
            entityArray = object2.toArray(new Entity[object2.size()]);
        } else if (string.startsWith("@r")) {
            object2 = ThreadLocalRandom.current();
            entityArray = new Entity[1];
            ArrayList<Entity> arrayList = new ArrayList<Entity>();
            for (World world : CommandUtils.getAcceptedWorldsFullString(location, string)) {
                boolean bl;
                if (CommandUtils.hasTag(SelectorType.TYPE, string)) {
                    for (Entity entity : world.getEntities()) {
                        bl = true;
                        for (String string5 : stringArray) {
                            if (CommandUtils.canBeAccepted(string5, entity, location)) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) continue;
                        arrayList.add(entity);
                    }
                    continue;
                }
                for (Entity entity : Bukkit.getOnlinePlayers()) {
                    bl = true;
                    for (String string5 : stringArray) {
                        if (CommandUtils.canBeAccepted(string5, entity, location)) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    arrayList.add(entity);
                }
            }
            entityArray[0] = (Entity)arrayList.get(((Random)object2).nextInt(arrayList.size()));
        } else {
            entityArray = new Entity[]{Bukkit.getPlayer((String)string)};
        }
        return entityArray;
    }

    public static Entity getTarget(CommandSender commandSender, String string) {
        Entity[] entityArray = CommandUtils.getTargets(commandSender, string);
        if (entityArray.length == 0) {
            return null;
        }
        return entityArray[0];
    }

    public static int getIntRelative(String string, String string2, Entity entity) {
        int n = 0;
        if (string.startsWith("~")) {
            switch (string2.toLowerCase()) {
                case "x": {
                    n = entity.getLocation().getBlockX();
                    break;
                }
                case "y": {
                    n = entity.getLocation().getBlockY();
                    break;
                }
                case "z": {
                    n = entity.getLocation().getBlockZ();
                }
            }
            return CommandUtils.mathIt(string, n);
        }
        if (string.startsWith("^")) {
            switch (string2.toLowerCase()) {
                case "x": {
                    n = entity.getLocation().getBlockX();
                    break;
                }
                case "y": {
                    n = entity.getLocation().getBlockY();
                    break;
                }
                case "z": {
                    n = entity.getLocation().getBlockZ();
                }
            }
            return CommandUtils.mathIt(string, n);
        }
        return 0;
    }

    private static boolean canBeAccepted(String string, Entity entity, Location location) {
        if (CommandUtils.hasTag(SelectorType.X_ROTATION, string) && CommandUtils.isWithinYaw(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.Y_ROTATION, string) && CommandUtils.isWithinPitch(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.TYPE, string) && CommandUtils.isType(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.NAME, string) && CommandUtils.isName(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.TEAM, string) && CommandUtils.isTeam(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.SCORE_FULL, string) && CommandUtils.isScore(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.SCORE_MIN, string) && CommandUtils.isScoreMin(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.SCORE_13, string) && CommandUtils.isScoreWithin(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.DISTANCE, string) && CommandUtils.isWithinDistance(string, location, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.LEVEL, string) && CommandUtils.isWithinLevel(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.TAG, string) && CommandUtils.isHasTags(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.RYM, string) && CommandUtils.isRYM(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.RXM, string) && CommandUtils.isRXM(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.HM, string) && CommandUtils.isHM(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.RY, string) && CommandUtils.isRY(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.RX, string) && CommandUtils.isRX(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.RM, string) && CommandUtils.isRM(string, location, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.LMax, string) && CommandUtils.isLM(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.L, string) && CommandUtils.isL(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.m, string) && CommandUtils.isM(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.H, string) && CommandUtils.isH(string, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.World, string) && CommandUtils.isW(string)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.R, string) && CommandUtils.isR(string, location, entity)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.X, string)) {
            return true;
        }
        if (CommandUtils.hasTag(SelectorType.Y, string)) {
            return true;
        }
        return CommandUtils.hasTag(SelectorType.Z, string);
    }

    private static String[] getTags(String string) {
        if (!string.contains("[")) {
            return new String[0];
        }
        String string2 = string.split("\\[")[1].split("\\]")[0];
        return string2.split(",");
    }

    private static int mathIt(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        String string2 = string.replace("~", String.valueOf(n));
        String string3 = "";
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '+' || string2.charAt(i) == '-' || string2.charAt(i) == '*' || string2.charAt(i) == '/') {
                try {
                    switch (n3) {
                        case 0: {
                            n2 += Integer.parseInt(string3);
                            break;
                        }
                        case 1: {
                            n2 -= Integer.parseInt(string3);
                            break;
                        }
                        case 2: {
                            n2 *= Integer.parseInt(string3);
                            break;
                        }
                        case 3: {
                            n2 /= Integer.parseInt(string3);
                        }
                    }
                    n3 = (short)(string2.charAt(i) == '+' ? 0 : (string2.charAt(i) == '-' ? 1 : (string2.charAt(i) == '*' ? 2 : (string2.charAt(i) == '/' ? 3 : -1))));
                }
                catch (Exception exception) {
                    Bukkit.getLogger().severe("There has been an issue with a plugin using the CommandUtils class!");
                }
                continue;
            }
            if (string.length() == i || string2.charAt(i) == ' ' || string2.charAt(i) == ',' || string2.charAt(i) == ']') {
                try {
                    switch (n3) {
                        case 0: {
                            n2 += Integer.parseInt(string3);
                            break;
                        }
                        case 1: {
                            n2 -= Integer.parseInt(string3);
                            break;
                        }
                        case 2: {
                            n2 *= Integer.parseInt(string3);
                            break;
                        }
                        case 3: {
                            n2 /= Integer.parseInt(string3);
                        }
                    }
                }
                catch (Exception exception) {
                    Bukkit.getLogger().severe("There has been an issue with a plugin using the CommandUtils class!");
                }
                break;
            }
            string3 = string3 + string2.charAt(i);
        }
        return n2;
    }

    private static int getLimit(String string) {
        if (CommandUtils.hasTag(SelectorType.LIMIT, string)) {
            for (String string2 : CommandUtils.getTags(string)) {
                if (!CommandUtils.hasTag(SelectorType.LIMIT, string2)) continue;
                return CommandUtils.getInt(string2);
            }
        }
        if (CommandUtils.hasTag(SelectorType.C, string)) {
            for (String string2 : CommandUtils.getTags(string)) {
                if (!CommandUtils.hasTag(SelectorType.C, string2)) continue;
                return CommandUtils.getInt(string2);
            }
        }
        return Integer.MAX_VALUE;
    }

    private static String getType(String string) {
        if (CommandUtils.hasTag(SelectorType.TYPE, string)) {
            return string.toLowerCase().split("=")[1].replace("!", "");
        }
        return "Player";
    }

    private static String getName(String string) {
        String string2 = string.replace(" ", "_");
        return string2.replace("!", "").split("=")[1];
    }

    private static World getW(String string) {
        return Bukkit.getWorld((String)CommandUtils.getString(string));
    }

    private static String getScoreMinName(String string) {
        return string.split("=")[0].substring(0, string.split("=")[0].length() - 1 - 4).replace("score_", "");
    }

    private static String getScoreName(String string) {
        return string.split("=")[0].replace("score_", "");
    }

    private static String getTeam(String string) {
        return string.toLowerCase().replace("!", "").split("=")[1];
    }

    private static int getValueAsInteger(String string) {
        return Integer.parseInt(string.replace("!", "").split("=")[1]);
    }

    private static GameMode getM(String string) {
        String[] stringArray = string.replace("!", "").toLowerCase().split("=");
        String string2 = stringArray[1];
        if (string2.equalsIgnoreCase("0") || string2.equalsIgnoreCase("s") || string2.equalsIgnoreCase("survival")) {
            return GameMode.SURVIVAL;
        }
        if (string2.equalsIgnoreCase("1") || string2.equalsIgnoreCase("c") || string2.equalsIgnoreCase("creative")) {
            return GameMode.CREATIVE;
        }
        if (string2.equalsIgnoreCase("2") || string2.equalsIgnoreCase("a") || string2.equalsIgnoreCase("adventure")) {
            return GameMode.ADVENTURE;
        }
        if (string2.equalsIgnoreCase("3") || string2.equalsIgnoreCase("sp") || string2.equalsIgnoreCase("spectator")) {
            return GameMode.SPECTATOR;
        }
        return null;
    }

    private static List<World> getAcceptedWorldsFullString(Location location, String string) {
        String string2 = null;
        for (String string3 : CommandUtils.getTags(string)) {
            if (!CommandUtils.hasTag(SelectorType.World, string3)) continue;
            string2 = string3;
            break;
        }
        if (string2 == null) {
            ArrayList arrayList = new ArrayList();
            if (location == null || location.getWorld() == null) {
                arrayList.addAll(Bukkit.getWorlds());
            } else {
                arrayList.add(location.getWorld());
            }
            return arrayList;
        }
        return CommandUtils.getAcceptedWorlds(string2);
    }

    private static List<World> getAcceptedWorlds(String string) {
        ArrayList<World> arrayList = new ArrayList<World>(Bukkit.getWorlds());
        if (CommandUtils.isInverted(string)) {
            arrayList.remove(CommandUtils.getW(string));
        } else {
            arrayList.clear();
            arrayList.add(CommandUtils.getW(string));
        }
        return arrayList;
    }

    private static boolean isTeam(String string, Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        for (Team team : Bukkit.getScoreboardManager().getMainScoreboard().getTeams()) {
            if (team.getName().equalsIgnoreCase(CommandUtils.getTeam(string)) == CommandUtils.isInverted(string) || team.getEntries().contains(((Player)entity).getName()) == CommandUtils.isInverted(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWithinPitch(String string, Entity entity) {
        return CommandUtils.isWithinDoubleValue(CommandUtils.isInverted(string), string, entity.getLocation().getPitch());
    }

    private static boolean isWithinYaw(String string, Entity entity) {
        return CommandUtils.isWithinDoubleValue(CommandUtils.isInverted(string), string, entity.getLocation().getYaw());
    }

    private static boolean isWithinDistance(String string, Location location, Entity entity) {
        double d = 0.0;
        double d2 = Double.MAX_VALUE;
        String string2 = string.split("=")[1];
        if (entity.getLocation().getWorld() != location.getWorld()) {
            return false;
        }
        if (string2.contains("..")) {
            double d3;
            String[] stringArray = string2.split("\\.\\.");
            if (!stringArray[0].isEmpty()) {
                d = Integer.parseInt(stringArray[0]);
            }
            if (stringArray.length > 1 && !stringArray[1].isEmpty()) {
                d2 = Double.parseDouble(stringArray[1]);
            }
            return (d3 = location.distanceSquared(entity.getLocation())) <= d2 * d2 && d * d <= d3;
        }
        int n = Integer.parseInt(string2);
        n *= n;
        return (int)location.distanceSquared(entity.getLocation()) == n;
    }

    private static boolean isWithinLevel(String string, Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        double d = 0.0;
        double d2 = Double.MAX_VALUE;
        String string2 = string.split("=")[1];
        if (string2.contains("..")) {
            double d3;
            String[] stringArray = string2.split("..");
            if (!stringArray[0].isEmpty()) {
                d = Integer.parseInt(stringArray[0]);
            }
            if (stringArray[1] != null && !stringArray[1].isEmpty()) {
                d2 = Double.parseDouble(stringArray[1]);
            }
            return (d3 = (double)((Player)entity).getExpToLevel()) <= d2 * d2 && d * d <= d3;
        }
        return ((Player)entity).getExpToLevel() == Integer.parseInt(string2);
    }

    private static boolean isScore(String string, Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        for (Objective objective : Bukkit.getScoreboardManager().getMainScoreboard().getObjectives()) {
            if (!objective.getName().equalsIgnoreCase(CommandUtils.getScoreName(string)) || objective.getScore(((Player)entity).getName()).getScore() <= CommandUtils.getValueAsInteger(string) == CommandUtils.isInverted(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isScoreWithin(String string, Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        String[] stringArray = string.split("\\{")[1].split("\\}")[0].split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            String string2 = stringArray2[0];
            for (Objective objective : Bukkit.getScoreboardManager().getMainScoreboard().getObjectives()) {
                if (!objective.getName().equalsIgnoreCase(string2) || CommandUtils.isWithinDoubleValue(CommandUtils.isInverted(string), stringArray2[1], objective.getScore(entity.getName()).getScore())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isHasTags(String string, Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        return CommandUtils.isInverted(string) != entity.getScoreboardTags().contains(CommandUtils.getString(string));
    }

    private static boolean isScoreMin(String string, Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        for (Objective objective : Bukkit.getScoreboardManager().getMainScoreboard().getObjectives()) {
            if (!objective.getName().equalsIgnoreCase(CommandUtils.getScoreMinName(string)) || objective.getScore(((Player)entity).getName()).getScore() >= CommandUtils.getValueAsInteger(string) == CommandUtils.isInverted(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRM(String string, Location location, Entity entity) {
        if (location.getWorld() != entity.getWorld()) {
            return false;
        }
        return CommandUtils.isGreaterThan(string, location.distance(entity.getLocation()));
    }

    private static boolean isR(String string, Location location, Entity entity) {
        if (location.getWorld() != entity.getWorld()) {
            return false;
        }
        return CommandUtils.isLessThan(string, location.distance(entity.getLocation()));
    }

    private static boolean isRXM(String string, Entity entity) {
        return CommandUtils.isLessThan(string, entity.getLocation().getYaw());
    }

    private static boolean isRX(String string, Entity entity) {
        return CommandUtils.isGreaterThan(string, entity.getLocation().getYaw());
    }

    private static boolean isRYM(String string, Entity entity) {
        return CommandUtils.isLessThan(string, entity.getLocation().getPitch());
    }

    private static boolean isRY(String string, Entity entity) {
        return CommandUtils.isGreaterThan(string, entity.getLocation().getPitch());
    }

    private static boolean isL(String string, Entity entity) {
        if (entity instanceof Player) {
            CommandUtils.isLessThan(string, ((Player)entity).getTotalExperience());
        }
        return false;
    }

    private static boolean isLM(String string, Entity entity) {
        if (entity instanceof Player) {
            return CommandUtils.isGreaterThan(string, ((Player)entity).getTotalExperience());
        }
        return false;
    }

    private static boolean isH(String string, Entity entity) {
        if (entity instanceof Damageable) {
            return CommandUtils.isGreaterThan(string, ((Damageable)entity).getHealth());
        }
        return false;
    }

    private static boolean isHM(String string, Entity entity) {
        if (entity instanceof Damageable) {
            return CommandUtils.isLessThan(string, ((Damageable)entity).getHealth());
        }
        return false;
    }

    private static boolean isM(String string, Entity entity) {
        if (CommandUtils.getM(string) == null) {
            return true;
        }
        return entity instanceof HumanEntity && CommandUtils.isInverted(string) != (CommandUtils.getM(string) == ((HumanEntity)entity).getGameMode());
    }

    private static boolean isW(String string) {
        if (CommandUtils.getW(string) == null) {
            return true;
        }
        return CommandUtils.isInverted(string) != CommandUtils.getAcceptedWorlds(string).contains(CommandUtils.getW(string));
    }

    private static boolean isName(String string, Entity entity) {
        if (CommandUtils.getName(string) == null) {
            return true;
        }
        return CommandUtils.isInverted(string) != (entity.getCustomName() != null) && CommandUtils.isInverted(string) != (CommandUtils.getName(string).equals(entity.getCustomName().replace(" ", "_")) || entity instanceof Player && ((Player)entity).getName().replace(" ", "_").equalsIgnoreCase(CommandUtils.getName(string)));
    }

    private static boolean isType(String string, Entity entity) {
        boolean bl = CommandUtils.isInverted(string);
        String string2 = CommandUtils.getType(string);
        return bl != entity.getType().name().equalsIgnoreCase(string2);
    }

    private static boolean isInverted(String string) {
        return string.toLowerCase().split("!").length != 1;
    }

    private static int getInt(String string) {
        int n = Integer.parseInt(string.split("=")[1]);
        return n;
    }

    public static String getString(String string) {
        return string.split("=")[1].replaceAll("!", "");
    }

    private static boolean isLessThan(String string, double d) {
        boolean bl = CommandUtils.isInverted(string);
        double d2 = Double.parseDouble(string.split("=")[1]);
        return d < d2 != bl;
    }

    private static boolean isGreaterThan(String string, double d) {
        boolean bl = CommandUtils.isInverted(string);
        double d2 = Double.parseDouble(string.split("=")[1]);
        return d > d2 != bl;
    }

    private static boolean isWithinDoubleValue(boolean bl, String string, double d) {
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        if (string.contains("..")) {
            String[] stringArray = string.split("\\.\\.");
            if (!stringArray[0].isEmpty()) {
                d2 = Integer.parseInt(stringArray[0]);
            }
            if (stringArray.length > 1 && !stringArray[1].isEmpty()) {
                d3 = Double.parseDouble(stringArray[1]);
            }
            return (d <= d3 * d3 && d2 * d2 <= d) != bl;
        }
        double d4 = Double.parseDouble(string);
        return d == d4 != bl;
    }

    private static boolean hasTag(SelectorType selectorType, String string) {
        return string.toLowerCase().startsWith(selectorType.getName());
    }

    static enum SelectorType {
        LEVEL("level="),
        DISTANCE("distance="),
        TYPE("type="),
        NAME("name="),
        TEAM("team="),
        LMax("lm="),
        L("l="),
        World("w="),
        m("m="),
        C("c="),
        HM("hm="),
        H("h="),
        RM("rm="),
        RYM("rym="),
        RX("rx="),
        SCORE_FULL("score="),
        SCORE_MIN("score_min"),
        SCORE_13("scores="),
        R("r="),
        RXM("rxm="),
        RY("ry="),
        TAG("tag="),
        X("x="),
        Y("y="),
        Z("z="),
        LIMIT("limit="),
        Y_ROTATION("y_rotation"),
        X_ROTATION("x_rotation");

        String name;

        private SelectorType(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }
    }
}

