/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.config;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.domain.Reward;
import com.hm.achievement.utils.MaterialHelper;
import com.hm.achievement.utils.StringHelper;
import com.hm.apache.commons.lang3.StringUtils;
import com.hm.apache.commons.lang3.math.NumberUtils;
import com.hm.apache.commons.text.WordUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.RegisteredServiceProvider;

@Singleton
public class RewardParser {
    private static final Pattern MULTIPLE_REWARDS_SPLITTER = Pattern.compile(";\\s*");
    private final YamlConfiguration mainConfig;
    private final YamlConfiguration langConfig;
    private final Server server;
    private final MaterialHelper materialHelper;
    private Economy economy;

    @Inject
    public RewardParser(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, AdvancedAchievements advancedAchievements, MaterialHelper materialHelper) {
        RegisteredServiceProvider registeredServiceProvider;
        this.mainConfig = yamlConfiguration;
        this.langConfig = yamlConfiguration2;
        this.materialHelper = materialHelper;
        this.server = advancedAchievements.getServer();
        if (this.server.getPluginManager().isPluginEnabled("Vault") && (registeredServiceProvider = this.server.getServicesManager().getRegistration(Economy.class)) != null) {
            this.economy = (Economy)registeredServiceProvider.getProvider();
        }
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public List<Reward> parseRewards(String string) {
        ConfigurationSection configurationSection = this.mainConfig.getConfigurationSection(string);
        ArrayList<Reward> arrayList = new ArrayList<Reward>();
        if (configurationSection != null) {
            if (this.economy != null && configurationSection.contains("Money")) {
                arrayList.add(this.parseMoneyReward(configurationSection));
            }
            if (configurationSection.contains("Item") || configurationSection.contains("Items")) {
                arrayList.add(this.parseItemReward(configurationSection));
            }
            if (configurationSection.contains("Experience")) {
                arrayList.add(this.parseExperienceReward(configurationSection));
            }
            if (configurationSection.contains("IncreaseMaxHealth")) {
                arrayList.add(this.parseIncreaseMaxHealthReward(configurationSection));
            }
            if (configurationSection.contains("IncreaseMaxOxygen")) {
                arrayList.add(this.parseIncreaseMaxOxygenReward(configurationSection));
            }
            if (configurationSection.contains("Command") || configurationSection.contains("Commands")) {
                arrayList.add(this.parseCommandReward(configurationSection));
            }
        }
        return arrayList;
    }

    private Reward parseMoneyReward(ConfigurationSection configurationSection) {
        int n = configurationSection.getInt("Money");
        String string = n > 1 ? this.economy.currencyNamePlural() : this.economy.currencyNameSingular();
        String string2 = StringUtils.replaceOnce(this.langConfig.getString("list-reward-money"), "AMOUNT", n + " " + string);
        String string3 = ChatColor.translateAlternateColorCodes((char)'&', (String)StringUtils.replaceOnce(this.langConfig.getString("money-reward-received"), "AMOUNT", n + " " + string));
        Consumer<Player> consumer = player -> this.economy.depositPlayer((OfflinePlayer)player, (double)n);
        return new Reward(Collections.singletonList(string2), Collections.singletonList(string3), consumer);
    }

    private Reward parseItemReward(ConfigurationSection configurationSection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<ItemStack> arrayList3 = new ArrayList<ItemStack>();
        String string = configurationSection.contains("Item") ? "Item" : "Items";
        for (String string2 : this.getOneOrManyConfigStrings(configurationSection, string)) {
            Object[] objectArray;
            Optional<Material> optional;
            if (!string2.contains(" ") || !(optional = this.materialHelper.matchMaterial((objectArray = StringUtils.split(string2))[0], "config.yml (" + configurationSection.getCurrentPath() + ".Item" + ")")).isPresent()) continue;
            int n = NumberUtils.toInt(objectArray[1], 1);
            ItemStack itemStack = new ItemStack(optional.get(), n);
            String string3 = StringUtils.join(objectArray, " ", 2, objectArray.length);
            if (string3.isEmpty()) {
                string3 = WordUtils.capitalizeFully(itemStack.getType().toString().replace('_', ' '));
            } else {
                ItemMeta itemMeta = itemStack.getItemMeta();
                if (itemMeta != null) {
                    itemMeta.setDisplayName(string3);
                    itemStack.setItemMeta(itemMeta);
                }
            }
            arrayList.add(StringUtils.replaceEach(this.langConfig.getString("list-reward-item"), new String[]{"AMOUNT", "ITEM"}, new String[]{Integer.toString(n), string3}));
            arrayList2.add(StringUtils.replaceEach(this.langConfig.getString("item-reward-received"), new String[]{"AMOUNT", "ITEM"}, new String[]{Integer.toString(n), string3}));
            arrayList3.add(itemStack);
        }
        Consumer<Player> consumer = player -> arrayList3.forEach(itemStack -> {
            ItemStack itemStack2 = itemStack.clone();
            ItemMeta itemMeta = itemStack2.getItemMeta();
            if (itemMeta != null && itemMeta.hasDisplayName()) {
                itemMeta.setDisplayName(StringHelper.replacePlayerPlaceholders(itemMeta.getDisplayName(), player));
                itemStack2.setItemMeta(itemMeta);
            }
            HashMap hashMap = player.getInventory().addItem(new ItemStack[]{itemStack2});
            for (ItemStack itemStack3 : hashMap.values()) {
                player.getWorld().dropItem(player.getLocation(), itemStack3);
            }
        });
        return new Reward(arrayList, arrayList2, consumer);
    }

    private Reward parseExperienceReward(ConfigurationSection configurationSection) {
        int n = configurationSection.getInt("Experience");
        String string = StringUtils.replaceOnce(this.langConfig.getString("list-reward-experience"), "AMOUNT", Integer.toString(n));
        String string2 = ChatColor.translateAlternateColorCodes((char)'&', (String)StringUtils.replaceOnce(this.langConfig.getString("experience-reward-received"), "AMOUNT", Integer.toString(n)));
        Consumer<Player> consumer = player -> player.giveExp(n);
        return new Reward(Collections.singletonList(string), Collections.singletonList(string2), consumer);
    }

    private Reward parseIncreaseMaxHealthReward(ConfigurationSection configurationSection) {
        int n = configurationSection.getInt("IncreaseMaxHealth");
        String string = StringUtils.replaceOnce(this.langConfig.getString("list-reward-increase-max-health"), "AMOUNT", Integer.toString(n));
        String string2 = ChatColor.translateAlternateColorCodes((char)'&', (String)StringUtils.replaceOnce(this.langConfig.getString("increase-max-health-reward-received"), "AMOUNT", Integer.toString(n)));
        Consumer<Player> consumer = player -> {
            AttributeInstance attributeInstance = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            attributeInstance.setBaseValue(attributeInstance.getBaseValue() + (double)n);
        };
        return new Reward(Collections.singletonList(string), Collections.singletonList(string2), consumer);
    }

    private Reward parseIncreaseMaxOxygenReward(ConfigurationSection configurationSection) {
        int n = configurationSection.getInt("IncreaseMaxOxygen");
        String string = StringUtils.replaceOnce(this.langConfig.getString("list-reward-increase-max-oxygen"), "AMOUNT", Integer.toString(n));
        String string2 = ChatColor.translateAlternateColorCodes((char)'&', (String)StringUtils.replaceOnce(this.langConfig.getString("increase-max-oxygen-reward-received"), "AMOUNT", Integer.toString(n)));
        Consumer<Player> consumer = player -> player.setMaximumAir(player.getMaximumAir() + n);
        return new Reward(Collections.singletonList(string), Collections.singletonList(string2), consumer);
    }

    private Reward parseCommandReward(ConfigurationSection configurationSection) {
        String string2 = configurationSection.contains("Command") ? "Command.Display" : "Commands.Display";
        List<String> list = this.getOneOrManyConfigStrings(configurationSection, string2);
        List<String> list2 = list.stream().map(string -> StringUtils.replace(this.langConfig.getString("custom-command-reward"), "MESSAGE", string)).collect(Collectors.toList());
        String string3 = configurationSection.contains("Command") ? "Command.Execute" : "Commands.Execute";
        Consumer<Player> consumer = player -> this.getOneOrManyConfigStrings(configurationSection, string3).stream().map(string -> StringHelper.replacePlayerPlaceholders(string, player)).forEach(string -> this.server.dispatchCommand((CommandSender)this.server.getConsoleSender(), string));
        return new Reward(list, list2, consumer);
    }

    private List<String> getOneOrManyConfigStrings(ConfigurationSection configurationSection, String string) {
        if (configurationSection.isList(string)) {
            return configurationSection.getStringList(string);
        }
        String string2 = configurationSection.getString(string);
        if (string2 != null) {
            return Arrays.asList(MULTIPLE_REWARDS_SPLITTER.split(StringUtils.normalizeSpace(string2)));
        }
        return Collections.emptyList();
    }
}

