/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.db;

import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.db.DatabaseUpdater;
import com.hm.achievement.db.SQLReadOperation;
import com.hm.achievement.db.SQLWriteOperation;
import com.hm.achievement.db.data.AwardedDBAchievement;
import com.hm.achievement.db.data.ConnectionInformation;
import com.hm.achievement.exception.PluginLoadError;
import com.hm.achievement.lifecycle.Reloadable;
import com.hm.apache.commons.lang3.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class AbstractDatabaseManager
implements Reloadable {
    final YamlConfiguration mainConfig;
    final Logger logger;
    final String driverPath;
    final ExecutorService writeExecutor;
    volatile String prefix;
    private final AtomicReference<Connection> connectionHolder = new AtomicReference();
    private final DatabaseUpdater databaseUpdater;
    private DateFormat dateFormat;
    private boolean configBookChronologicalOrder;
    private boolean initialised = false;

    public AbstractDatabaseManager(YamlConfiguration yamlConfiguration, Logger logger, DatabaseUpdater databaseUpdater, String string, ExecutorService executorService) {
        this.mainConfig = yamlConfiguration;
        this.logger = logger;
        this.databaseUpdater = databaseUpdater;
        this.driverPath = string;
        this.writeExecutor = executorService;
    }

    @Override
    public void extractConfigurationParameters() {
        this.configBookChronologicalOrder = this.mainConfig.getBoolean("BookChronologicalOrder");
        String string = this.mainConfig.getString("DateLocale");
        boolean bl = this.mainConfig.getBoolean("DateDisplayTime");
        Locale locale = new Locale(string);
        this.dateFormat = bl ? DateFormat.getDateTimeInstance(2, 3, locale) : DateFormat.getDateInstance(2, locale);
    }

    public void initialise() {
        this.logger.info("Initialising " + this.mainConfig.getString("DatabaseType") + " database...");
        this.prefix = this.mainConfig.getString("TablePrefix");
        try {
            this.performPreliminaryTasks();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.severe("The JBDC driver for the chosen database type was not found.");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.log(Level.SEVERE, "Error while encoding the database URL:", unsupportedEncodingException);
        }
        if (this.getConnection() == null) {
            throw new PluginLoadError("Failed to establish database connection. Please verify your settings in config.yml.");
        }
        this.databaseUpdater.renameExistingTables(this);
        int n = this.mainConfig.getInt("TableMaxSizeOfGroupedSubcategories");
        this.databaseUpdater.initialiseTables(this, n);
        Arrays.stream(MultipleAchievements.values()).forEach(multipleAchievements -> this.databaseUpdater.updateOldDBColumnSize(this, (MultipleAchievements)multipleAchievements, n));
        this.initialised = true;
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    abstract void performPreliminaryTasks();

    public void shutdown() {
        this.writeExecutor.shutdown();
        try {
            if (!this.writeExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.logger.warning("Some write operations could not be sent to the database during plugin shutdown.");
            }
        }
        catch (InterruptedException interruptedException) {
            this.logger.log(Level.SEVERE, "Error while waiting for database write operations to complete:", interruptedException);
            Thread.currentThread().interrupt();
        }
        finally {
            try {
                Connection connection = this.connectionHolder.get();
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(Level.SEVERE, "Error while closing connection to the database:", sQLException);
            }
        }
    }

    Connection getConnection() {
        Connection connection = this.connectionHolder.get();
        try {
            if (connection == null || connection.isClosed()) {
                Connection connection2 = this.createConnection();
                if (!this.connectionHolder.compareAndSet(connection, connection2)) {
                    connection2.close();
                }
                return this.connectionHolder.get();
            }
        }
        catch (SQLException sQLException) {
            this.logger.log(Level.SEVERE, "Error while attempting to retrieve a connection to the database:", sQLException);
        }
        return connection;
    }

    abstract Connection createConnection();

    public Set<String> getPlayerAchievementNames(UUID uUID) {
        return ((SQLReadOperation<Set>)() -> {
            String string = "SELECT achievement FROM " + this.prefix + "achievements WHERE playername = ?";
            HashSet<String> hashSet = new HashSet<String>();
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string);){
                preparedStatement.setString(1, uUID.toString());
                preparedStatement.setFetchSize(1000);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        hashSet.add(resultSet.getString(1));
                    }
                }
            }
            return hashSet;
        }).executeOperation("retrieving the names of received achievements");
    }

    public String getPlayerAchievementDate(UUID uUID, String string) {
        return ((SQLReadOperation<String>)() -> {
            String string2 = "SELECT date FROM " + this.prefix + "achievements WHERE playername = ? AND achievement = ?";
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string2);){
                preparedStatement.setString(1, uUID.toString());
                preparedStatement.setString(2, string);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        String string3 = this.dateFormat.format(new Date(resultSet.getTimestamp(1).getTime()));
                        return string3;
                    }
                }
            }
            return null;
        }).executeOperation("retrieving an achievement's reception date");
    }

    public Map<UUID, Integer> getPlayersAchievementsAmount() {
        return ((SQLReadOperation<Map>)() -> {
            String string = "SELECT playername, COUNT(*) FROM " + this.prefix + "achievements GROUP BY playername";
            HashMap<UUID, Integer> hashMap = new HashMap<UUID, Integer>();
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string);){
                preparedStatement.setFetchSize(1000);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        String string2 = resultSet.getString(1);
                        if (!StringUtils.isNotEmpty(string2)) continue;
                        hashMap.put(UUID.fromString(string2), resultSet.getInt(2));
                    }
                }
            }
            return hashMap;
        }).executeOperation("counting all players' achievements");
    }

    public Map<String, Integer> getTopList(long l) {
        return ((SQLReadOperation<Map>)() -> {
            String string = l == 0L ? "SELECT playername, COUNT(*) FROM " + this.prefix + "achievements GROUP BY playername ORDER BY COUNT(*) DESC" : "SELECT playername, COUNT(*) FROM " + this.prefix + "achievements WHERE date > ? GROUP BY playername ORDER BY COUNT(*) DESC";
            LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string);){
                if (l > 0L) {
                    preparedStatement.setTimestamp(1, new Timestamp(l));
                }
                preparedStatement.setFetchSize(1000);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        linkedHashMap.put(resultSet.getString(1), resultSet.getInt(2));
                    }
                }
            }
            return linkedHashMap;
        }).executeOperation("computing the list of top players");
    }

    public void registerAchievement(UUID uUID, String string, long l) {
        ((SQLWriteOperation)() -> {
            String string2 = "REPLACE INTO " + this.prefix + "achievements VALUES (?,?,?)";
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string2);){
                preparedStatement.setString(1, uUID.toString());
                preparedStatement.setString(2, string);
                preparedStatement.setTimestamp(3, new Timestamp(l));
                preparedStatement.execute();
            }
        }).executeOperation(this.writeExecutor, this.logger, "registering an achievement");
    }

    public long getNormalAchievementAmount(UUID uUID, NormalAchievements normalAchievements) {
        return ((SQLReadOperation<Long>)() -> {
            String string = normalAchievements.toDBName();
            String string2 = "SELECT " + string + " FROM " + this.prefix + string + " WHERE playername = ?";
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string2);){
                preparedStatement.setString(1, uUID.toString());
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        Long l = resultSet.getLong(1);
                        return l;
                    }
                }
            }
            return 0L;
        }).executeOperation("retrieving " + normalAchievements + " statistics");
    }

    public long getMultipleAchievementAmount(UUID uUID, MultipleAchievements multipleAchievements, String string) {
        return ((SQLReadOperation<Long>)() -> {
            String string2 = multipleAchievements.toDBName();
            String string3 = "SELECT " + string2 + " FROM " + this.prefix + string2 + " WHERE playername = ? AND " + multipleAchievements.toSubcategoryDBName() + " = ?";
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string3);){
                preparedStatement.setString(1, uUID.toString());
                preparedStatement.setString(2, string);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        Long l = resultSet.getLong(1);
                        return l;
                    }
                }
            }
            return multipleAchievements == MultipleAchievements.JOBSREBORN ? 1L : 0L;
        }).executeOperation("retrieving " + multipleAchievements + "." + string + " statistics");
    }

    public ConnectionInformation getConnectionInformation(UUID uUID) {
        return ((SQLReadOperation<ConnectionInformation>)() -> {
            String string = NormalAchievements.CONNECTIONS.toDBName();
            String string2 = "SELECT " + string + ", date FROM " + this.prefix + string + " WHERE playername = ?";
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string2);){
                preparedStatement.setString(1, uUID.toString());
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        ConnectionInformation connectionInformation = new ConnectionInformation(resultSet.getString(2), resultSet.getLong(1));
                        return connectionInformation;
                    }
                }
            }
            return new ConnectionInformation();
        }).executeOperation("retrieving a player's connection information");
    }

    public void updateConnectionInformation(UUID uUID, long l) {
        ((SQLWriteOperation)() -> {
            String string = "REPLACE INTO " + this.prefix + NormalAchievements.CONNECTIONS.toDBName() + " VALUES (?,?,?)";
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string);){
                preparedStatement.setString(1, uUID.toString());
                preparedStatement.setLong(2, l);
                preparedStatement.setString(3, ConnectionInformation.today());
                preparedStatement.execute();
            }
        }).executeOperation(this.writeExecutor, this.logger, "updating connection date and count");
    }

    public void deletePlayerAchievement(UUID uUID, String string) {
        ((SQLWriteOperation)() -> {
            String string2 = "DELETE FROM " + this.prefix + "achievements WHERE playername = ? AND achievement = ?";
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string2);){
                preparedStatement.setString(1, uUID.toString());
                preparedStatement.setString(2, string);
                preparedStatement.execute();
            }
        }).executeOperation(this.writeExecutor, this.logger, "deleting an achievement");
    }

    public void deleteAllPlayerAchievements(UUID uUID) {
        ((SQLWriteOperation)() -> {
            String string = "DELETE FROM " + this.prefix + "achievements WHERE playername = ?";
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string);){
                preparedStatement.setString(1, uUID.toString());
                preparedStatement.execute();
            }
        }).executeOperation(this.writeExecutor, this.logger, "deleting all achievements");
    }

    public void clearConnection(UUID uUID) {
        ((SQLWriteOperation)() -> {
            String string = "DELETE FROM " + this.prefix + "connections WHERE playername = '" + uUID + "'";
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string);){
                preparedStatement.execute();
            }
        }).executeOperation(this.writeExecutor, this.logger, "clearing connection statistics");
    }

    String getPrefix() {
        return this.prefix;
    }

    public List<AwardedDBAchievement> getPlayerAchievementsList(UUID uUID) {
        return ((SQLReadOperation<List>)() -> {
            String string = "SELECT achievement, date FROM " + this.prefix + "achievements WHERE playername = ? ORDER BY date " + (this.configBookChronologicalOrder ? "ASC" : "DESC");
            ArrayList<AwardedDBAchievement> arrayList = new ArrayList<AwardedDBAchievement>();
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string);){
                preparedStatement.setFetchSize(1000);
                preparedStatement.setString(1, uUID.toString());
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        Timestamp timestamp = resultSet.getTimestamp(2);
                        arrayList.add(new AwardedDBAchievement(uUID, resultSet.getString(1), timestamp.getTime(), this.dateFormat.format(timestamp)));
                    }
                }
            }
            return arrayList;
        }).executeOperation("retrieving the full data of received achievements");
    }

    public List<AwardedDBAchievement> getAchievementsRecipientList(String string) {
        String string2 = "SELECT playername, date FROM " + this.prefix + "achievements WHERE achievement = ? ORDER BY date DESC LIMIT 1000";
        return ((SQLReadOperation<List>)() -> {
            ArrayList<AwardedDBAchievement> arrayList = new ArrayList<AwardedDBAchievement>();
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string2);){
                preparedStatement.setFetchSize(1000);
                preparedStatement.setString(1, string);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        UUID uUID;
                        Object object;
                        try {
                            object = resultSet.getString(1);
                            uUID = UUID.fromString((String)object);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            continue;
                        }
                        object = new Date(resultSet.getTimestamp(2).getTime());
                        arrayList.add(new AwardedDBAchievement(uUID, string, ((java.util.Date)object).getTime(), this.dateFormat.format((java.util.Date)object)));
                    }
                }
            }
            return arrayList;
        }).executeOperation("retrieving the recipients of an achievement");
    }
}

