/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.db;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.db.DatabaseUpdater;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Named;
import org.bukkit.configuration.file.YamlConfiguration;

public class AbstractFileDatabaseManager
extends AbstractDatabaseManager {
    private final AdvancedAchievements advancedAchievements;
    private final String url;
    private final String filename;

    public AbstractFileDatabaseManager(@Named(value="main") YamlConfiguration yamlConfiguration, Logger logger, DatabaseUpdater databaseUpdater, AdvancedAchievements advancedAchievements, String string, String string2, String string3, ExecutorService executorService) {
        super(yamlConfiguration, logger, databaseUpdater, string, executorService);
        this.advancedAchievements = advancedAchievements;
        this.url = string2;
        this.filename = string3;
    }

    @Override
    void performPreliminaryTasks() {
        Class.forName(this.driverPath);
        if (this.mainConfig.getBoolean("DatabaseBackup")) {
            File file = new File(this.advancedAchievements.getDataFolder(), this.filename + ".bak");
            File file2 = new File(this.advancedAchievements.getDataFolder(), this.filename);
            if (file2.lastModified() - file.lastModified() > TimeUnit.DAYS.toMillis(1L)) {
                this.logger.info("Backing up database file...");
                try {
                    Files.copy(file2.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    this.logger.log(Level.SEVERE, "Error while backing up database file:", iOException);
                }
            }
        }
    }

    @Override
    Connection createConnection() {
        return DriverManager.getConnection(this.url);
    }
}

