/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.db;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.db.CachedStatistic;
import com.hm.achievement.db.SubcategoryUUID;
import com.hm.achievement.lifecycle.Cleanable;
import com.hm.apache.commons.lang3.StringUtils;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

@Singleton
public class CacheManager
implements Cleanable {
    private final AdvancedAchievements advancedAchievements;
    private final AbstractDatabaseManager databaseManager;
    private final Map<NormalAchievements, Map<UUID, CachedStatistic>> normalAchievementsToPlayerStatistics;
    private final Map<MultipleAchievements, Map<SubcategoryUUID, CachedStatistic>> multipleAchievementsToPlayerStatistics;
    private final Map<UUID, Set<String>> receivedAchievementsCache;

    @Inject
    public CacheManager(AdvancedAchievements advancedAchievements, AbstractDatabaseManager abstractDatabaseManager) {
        this.advancedAchievements = advancedAchievements;
        this.databaseManager = abstractDatabaseManager;
        this.normalAchievementsToPlayerStatistics = new EnumMap<NormalAchievements, Map<UUID, CachedStatistic>>(NormalAchievements.class);
        this.multipleAchievementsToPlayerStatistics = new EnumMap<MultipleAchievements, Map<SubcategoryUUID, CachedStatistic>>(MultipleAchievements.class);
        this.receivedAchievementsCache = new ConcurrentHashMap<UUID, Set<String>>();
        for (NormalAchievements enum_ : NormalAchievements.values()) {
            this.normalAchievementsToPlayerStatistics.put(enum_, new ConcurrentHashMap());
        }
        for (Enum enum_ : MultipleAchievements.values()) {
            this.multipleAchievementsToPlayerStatistics.put((MultipleAchievements)enum_, new ConcurrentHashMap());
        }
    }

    @Override
    public void cleanPlayerData() {
        this.receivedAchievementsCache.keySet().removeIf(uUID -> !Bukkit.getOfflinePlayer((UUID)uUID).isOnline());
        for (MultipleAchievements enum_ : MultipleAchievements.values()) {
            for (Map.Entry<SubcategoryUUID, CachedStatistic> entry : this.getHashMap(enum_).entrySet()) {
                if (Bukkit.getOfflinePlayer((UUID)entry.getKey().getUUID()).isOnline()) continue;
                entry.getValue().signalPlayerDisconnection();
            }
        }
        for (Enum enum_ : NormalAchievements.values()) {
            for (Map.Entry<Object, CachedStatistic> entry : this.getHashMap((NormalAchievements)enum_).entrySet()) {
                if (Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey())).isOnline()) continue;
                entry.getValue().signalPlayerDisconnection();
            }
        }
    }

    public void cleanStaleCaches() {
        for (MultipleAchievements enum_ : MultipleAchievements.values()) {
            this.cleanStaleCache(this.getHashMap(enum_), SubcategoryUUID::getUUID);
        }
        for (Enum enum_ : NormalAchievements.values()) {
            this.cleanStaleCache(this.getHashMap((NormalAchievements)enum_), uUID -> uUID);
        }
    }

    private <T> void cleanStaleCache(Map<T, CachedStatistic> map, Function<T, UUID> function) {
        for (Map.Entry<T, CachedStatistic> entry : map.entrySet()) {
            Object t = entry.getKey();
            UUID uUID = function.apply(t);
            CachedStatistic cachedStatistic = entry.getValue();
            if (!cachedStatistic.didPlayerDisconnect() || !cachedStatistic.isDatabaseConsistent()) continue;
            Bukkit.getScheduler().callSyncMethod((Plugin)this.advancedAchievements, () -> {
                if (cachedStatistic.isDatabaseConsistent()) {
                    map.remove(t);
                } else if (Bukkit.getPlayer((UUID)uUID) != null) {
                    cachedStatistic.resetDisconnection();
                }
                return null;
            });
        }
    }

    public Map<UUID, CachedStatistic> getHashMap(NormalAchievements normalAchievements) {
        return this.normalAchievementsToPlayerStatistics.get(normalAchievements);
    }

    public Map<SubcategoryUUID, CachedStatistic> getHashMap(MultipleAchievements multipleAchievements) {
        return this.multipleAchievementsToPlayerStatistics.get(multipleAchievements);
    }

    public long getAndIncrementStatisticAmount(NormalAchievements normalAchievements, UUID uUID, int n) {
        Map<UUID, CachedStatistic> map = this.getHashMap(normalAchievements);
        CachedStatistic cachedStatistic = map.get(uUID);
        if (cachedStatistic == null) {
            cachedStatistic = new CachedStatistic(this.databaseManager.getNormalAchievementAmount(uUID, normalAchievements), true);
            map.put(uUID, cachedStatistic);
        }
        if (n != 0) {
            cachedStatistic.setValue(cachedStatistic.getValue() + (long)n);
        }
        return cachedStatistic.getValue();
    }

    public long getAndIncrementStatisticAmount(MultipleAchievements multipleAchievements, String string, UUID uUID, int n) {
        SubcategoryUUID subcategoryUUID = new SubcategoryUUID(string, uUID);
        Map<SubcategoryUUID, CachedStatistic> map = this.getHashMap(multipleAchievements);
        CachedStatistic cachedStatistic = map.get(subcategoryUUID);
        if (cachedStatistic == null) {
            cachedStatistic = new CachedStatistic(this.databaseManager.getMultipleAchievementAmount(uUID, multipleAchievements, subcategoryUUID.getSubcategory()), true);
            map.put(subcategoryUUID, cachedStatistic);
        }
        if (n != 0) {
            cachedStatistic.setValue(cachedStatistic.getValue() + (long)n);
        }
        return cachedStatistic.getValue();
    }

    public boolean hasPlayerAchievement(UUID uUID, String string) {
        return this.receivedAchievementsCache.computeIfAbsent(uUID, this.databaseManager::getPlayerAchievementNames).contains(string);
    }

    public Set<String> getPlayerAchievements(UUID uUID) {
        return this.receivedAchievementsCache.computeIfAbsent(uUID, this.databaseManager::getPlayerAchievementNames);
    }

    public void registerNewlyReceivedAchievement(UUID uUID, String string) {
        this.receivedAchievementsCache.computeIfAbsent(uUID, this.databaseManager::getPlayerAchievementNames).add(string);
    }

    public void removePreviouslyReceivedAchievements(UUID uUID, Collection<String> collection) {
        this.receivedAchievementsCache.computeIfAbsent(uUID, this.databaseManager::getPlayerAchievementNames).removeAll(collection);
    }

    public void resetPlayerStatistics(UUID uUID, Collection<String> collection) {
        collection.forEach(string -> {
            if (string.contains(".")) {
                String string2 = StringUtils.substringBefore(string, ".");
                String string3 = StringUtils.substringAfter(string, ".");
                SubcategoryUUID subcategoryUUID = new SubcategoryUUID(string3, uUID);
                Map<SubcategoryUUID, CachedStatistic> map = this.getHashMap(MultipleAchievements.getByName(string2));
                CachedStatistic cachedStatistic = map.get(subcategoryUUID);
                if (cachedStatistic == null) {
                    map.put(subcategoryUUID, new CachedStatistic(0L, false));
                } else {
                    cachedStatistic.setValue(0L);
                }
            } else {
                NormalAchievements normalAchievements = NormalAchievements.getByName(string);
                if (normalAchievements == NormalAchievements.CONNECTIONS) {
                    this.databaseManager.clearConnection(uUID);
                } else {
                    Map<UUID, CachedStatistic> map = this.getHashMap(normalAchievements);
                    CachedStatistic cachedStatistic = map.get(uUID);
                    if (cachedStatistic == null) {
                        map.put(uUID, new CachedStatistic(0L, false));
                    } else {
                        cachedStatistic.setValue(0L);
                    }
                }
            }
        });
    }
}

