/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.db;

import com.hm.achievement.exception.DatabaseReadError;
import java.sql.SQLException;

@FunctionalInterface
public interface SQLReadOperation<T> {
    public static final int MAX_ATTEMPTS = 3;

    public T performRead() throws SQLException;

    default public T executeOperation(String operationMessage) {
        SQLException cause = null;
        for (int attempt = 1; attempt <= 3; ++attempt) {
            try {
                return this.performRead();
            }
            catch (SQLException e) {
                cause = e;
                continue;
            }
        }
        throw new DatabaseReadError("Database read error while " + operationMessage + ".", cause);
    }
}

