/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.gui;

import com.hm.achievement.category.CommandAchievements;
import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.gui.OrderedCategory;
import com.hm.achievement.lifecycle.Reloadable;
import com.hm.achievement.utils.MaterialHelper;
import com.hm.achievement.utils.StringHelper;
import com.hm.apache.commons.lang3.StringUtils;
import com.hm.apache.commons.text.StringEscapeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Singleton
public class GUIItems
implements Reloadable {
    private final Map<OrderedCategory, ItemStack> orderedAchievementItems = new TreeMap<OrderedCategory, ItemStack>();
    private ItemStack previousButton;
    private ItemStack nextButton;
    private ItemStack backButton;
    private ItemStack achievementNotStartedDefault;
    private final Map<String, ItemStack> achievementNotStarted = new HashMap<String, ItemStack>();
    private ItemStack achievementStartedDefault;
    private final Map<String, ItemStack> achievementStarted = new HashMap<String, ItemStack>();
    private ItemStack achievementReceivedDefault;
    private final Map<String, ItemStack> achievementReceived = new HashMap<String, ItemStack>();
    private ItemStack achievementLock;
    private ItemStack categoryLock;
    private final YamlConfiguration mainConfig;
    private final YamlConfiguration langConfig;
    private final YamlConfiguration guiConfig;
    private final MaterialHelper materialHelper;
    private String configListAchievementFormat;
    private String configIcon;

    @Inject
    public GUIItems(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, @Named(value="gui") YamlConfiguration yamlConfiguration3, MaterialHelper materialHelper) {
        this.mainConfig = yamlConfiguration;
        this.langConfig = yamlConfiguration2;
        this.guiConfig = yamlConfiguration3;
        this.materialHelper = materialHelper;
    }

    @Override
    public void extractConfigurationParameters() {
        ItemStack itemStack;
        String string;
        this.configListAchievementFormat = "&8" + this.mainConfig.getString("ListAchievementFormat");
        this.configIcon = StringEscapeUtils.unescapeJava(this.mainConfig.getString("Icon"));
        this.orderedAchievementItems.clear();
        ArrayList arrayList = new ArrayList(this.guiConfig.getKeys(false));
        for (MultipleAchievements multipleAchievements : MultipleAchievements.values()) {
            string = multipleAchievements.toString();
            itemStack = this.createItemStack(string);
            this.buildItemLore(itemStack, string);
            this.orderedAchievementItems.put(new OrderedCategory(arrayList.indexOf(string), multipleAchievements), itemStack);
        }
        for (NormalAchievements normalAchievements : NormalAchievements.values()) {
            string = normalAchievements.toString();
            itemStack = this.createItemStack(string);
            this.buildItemLore(itemStack, string);
            this.orderedAchievementItems.put(new OrderedCategory(arrayList.indexOf(string), normalAchievements), itemStack);
        }
        String string2 = CommandAchievements.COMMANDS.toString();
        ItemStack itemStack2 = this.createItemStack(string2);
        this.buildItemLore(itemStack2, string2);
        this.orderedAchievementItems.put(new OrderedCategory(arrayList.indexOf(string2), CommandAchievements.COMMANDS), itemStack2);
        this.achievementNotStartedDefault = new ItemStack(Material.RED_TERRACOTTA, 1);
        this.achievementStartedDefault = new ItemStack(Material.YELLOW_TERRACOTTA, 1);
        this.achievementReceivedDefault = new ItemStack(Material.LIME_TERRACOTTA, 1);
        for (String string3 : this.guiConfig.getConfigurationSection("AchievementNotStarted").getKeys(false)) {
            this.achievementNotStarted.put(string3, this.createItemStack("AchievementNotStarted." + string3));
        }
        for (String string4 : this.guiConfig.getConfigurationSection("AchievementStarted").getKeys(false)) {
            this.achievementStarted.put(string4, this.createItemStack("AchievementStarted." + string4));
        }
        for (String string5 : this.guiConfig.getConfigurationSection("AchievementReceived").getKeys(false)) {
            this.achievementReceived.put(string5, this.createItemStack("AchievementReceived." + string5));
        }
        this.previousButton = this.createButton("PreviousButton", "list-previous-message", "list-previous-lore");
        this.nextButton = this.createButton("NextButton", "list-next-message", "list-next-lore");
        this.backButton = this.createButton("BackButton", "list-back-message", "list-back-lore");
        this.achievementLock = this.createButton("AchievementLock", "list-achievement-not-unlocked", null);
        this.categoryLock = this.createButton("CategoryLock", "list-category-not-unlocked", null);
    }

    private ItemStack createItemStack(String string) {
        String string2 = string + ".Item";
        Material material = this.materialHelper.matchMaterial(this.guiConfig.getString(string2, null), Material.BEDROCK, "gui.yml (" + string2 + ")");
        return new ItemStack(material, 1);
    }

    private ItemStack createButton(String string, String string2, String string3) {
        String string4;
        ItemStack itemStack = this.createItemStack(string);
        ItemMeta itemMeta = itemStack.getItemMeta();
        String string5 = ChatColor.translateAlternateColorCodes((char)'&', (String)StringEscapeUtils.unescapeJava(this.langConfig.getString(string2)));
        itemMeta.setDisplayName(string5);
        if (string3 != null && !(string4 = ChatColor.translateAlternateColorCodes((char)'&', (String)StringEscapeUtils.unescapeJava(this.langConfig.getString(string3)))).isEmpty()) {
            itemMeta.setLore(Collections.singletonList(string4));
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private void buildItemLore(ItemStack itemStack, String string) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        String string2 = StringHelper.getClosestMatch("list-" + string.toLowerCase(), this.langConfig.getKeys(false));
        String string3 = this.langConfig.getString(string2);
        if (StringUtils.isBlank(string3)) {
            itemMeta.setDisplayName("");
        } else {
            String string4 = StringUtils.replaceEach(this.configListAchievementFormat, new String[]{"%ICON%", "%NAME%"}, new String[]{this.configIcon, "&l" + string3 + "&8"});
            itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)string4));
        }
        itemStack.setItemMeta(itemMeta);
    }

    public ItemStack getAchievementNotStarted(String string) {
        return this.achievementNotStarted.getOrDefault(string, this.achievementNotStartedDefault);
    }

    public ItemStack getAchievementStarted(String string) {
        return this.achievementStarted.getOrDefault(string, this.achievementStartedDefault);
    }

    public ItemStack getAchievementReceived(String string) {
        return this.achievementReceived.getOrDefault(string, this.achievementReceivedDefault);
    }

    public Map<OrderedCategory, ItemStack> getOrderedAchievementItems() {
        return this.orderedAchievementItems;
    }

    public ItemStack getPreviousButton() {
        return this.previousButton;
    }

    public ItemStack getNextButton() {
        return this.nextButton;
    }

    public ItemStack getBackButton() {
        return this.backButton;
    }

    public ItemStack getAchievementLock() {
        return this.achievementLock;
    }

    public ItemStack getCategoryLock() {
        return this.categoryLock;
    }
}

