/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener;

import com.hm.achievement.category.Category;
import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.gui.AchievementInventoryHolder;
import com.hm.achievement.gui.CategoryGUI;
import com.hm.achievement.gui.GUIItems;
import com.hm.achievement.gui.MainGUI;
import com.hm.apache.commons.lang3.StringUtils;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ListGUIListener
implements Listener {
    private final YamlConfiguration mainConfig;
    private final Set<Category> disabledCategories;
    private final MainGUI mainGUI;
    private final CategoryGUI categoryGUI;
    private final GUIItems guiItems;

    @Inject
    public ListGUIListener(@Named(value="main") YamlConfiguration yamlConfiguration, Set<Category> set, MainGUI mainGUI, CategoryGUI categoryGUI, GUIItems gUIItems) {
        this.mainConfig = yamlConfiguration;
        this.disabledCategories = set;
        this.mainGUI = mainGUI;
        this.categoryGUI = categoryGUI;
        this.guiItems = gUIItems;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        Inventory inventory = inventoryClickEvent.getInventory();
        if (!(inventory.getHolder() instanceof AchievementInventoryHolder) || inventoryClickEvent.getRawSlot() < 0) {
            return;
        }
        inventoryClickEvent.setCancelled(true);
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        AchievementInventoryHolder achievementInventoryHolder = (AchievementInventoryHolder)inventory.getHolder();
        int n = achievementInventoryHolder.getPageIndex();
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (n == -1) {
            if (!itemStack.isSimilar(this.guiItems.getCategoryLock()) && inventoryClickEvent.getRawSlot() < this.getMainGUIItemCount()) {
                this.categoryGUI.displayCategoryGUI(itemStack, player, 0);
            }
            return;
        }
        if (inventoryClickEvent.getRawSlot() == inventory.getSize() - 5) {
            String string = this.mainConfig.getString("OverrideBackButtonBehaviour");
            if (StringUtils.isBlank(string)) {
                this.mainGUI.displayMainGUI(player);
            } else {
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), StringUtils.replace(string, "PLAYER", player.getName()));
            }
        } else if (inventoryClickEvent.getRawSlot() == inventory.getSize() - 9) {
            this.categoryGUI.displayCategoryGUI(achievementInventoryHolder.getCategoryItem(), player, n - 1);
        } else if (inventoryClickEvent.getRawSlot() == inventory.getSize() - 1) {
            this.categoryGUI.displayCategoryGUI(achievementInventoryHolder.getCategoryItem(), player, n + 1);
        }
    }

    private int getMainGUIItemCount() {
        return NormalAchievements.values().length + MultipleAchievements.values().length - this.disabledCategories.size() + 1;
    }
}

