/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener;

import com.hm.achievement.runnable.AchieveDistanceRunnable;
import javax.inject.Inject;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TeleportListener
implements Listener {
    private final AchieveDistanceRunnable distanceRunnable;

    @Inject
    public TeleportListener(AchieveDistanceRunnable achieveDistanceRunnable) {
        this.distanceRunnable = achieveDistanceRunnable;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerRespawn(PlayerRespawnEvent playerRespawnEvent) {
        this.distanceRunnable.updateLocation(playerRespawnEvent.getPlayer().getUniqueId(), playerRespawnEvent.getRespawnLocation());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent playerTeleportEvent) {
        if (playerTeleportEvent.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL) {
            return;
        }
        this.distanceRunnable.updateLocation(playerTeleportEvent.getPlayer().getUniqueId(), playerTeleportEvent.getTo());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityTeleport(EntityTeleportEvent entityTeleportEvent) {
        for (Entity entity : entityTeleportEvent.getEntity().getPassengers()) {
            if (!(entity instanceof Player)) continue;
            this.distanceRunnable.updateLocation(((Player)entity).getUniqueId(), entityTeleportEvent.getTo());
        }
    }
}

