/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.category.Category;
import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.utils.StatisticIncreaseHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public abstract class AbstractListener
extends StatisticIncreaseHandler
implements Listener {
    final Category category;
    List<String> subcategories;

    AbstractListener(Category category, YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager) {
        super(yamlConfiguration, achievementMap, cacheManager);
        this.category = category;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.subcategories = new ArrayList<String>(this.achievementMap.getSubcategoriesForCategory(this.category));
    }

    public Category getCategory() {
        return this.category;
    }

    void updateStatisticAndAwardAchievementsIfAvailable(Player player, int n) {
        if (this.shouldIncreaseBeTakenIntoAccount(player, this.category)) {
            long l = this.cacheManager.getAndIncrementStatisticAmount((NormalAchievements)this.category, player.getUniqueId(), n);
            this.checkThresholdsAndAchievements(player, this.category, l);
        }
    }

    void updateStatisticAndAwardAchievementsIfAvailable(Player player, Set<String> set, int n) {
        if (this.shouldIncreaseBeTakenIntoAccount(player, this.category)) {
            set.forEach(string -> {
                long l = this.cacheManager.getAndIncrementStatisticAmount((MultipleAchievements)this.category, (String)string, player.getUniqueId(), n);
                this.checkThresholdsAndAchievements(player, this.category, (String)string, l);
            });
        }
    }

    void addMatchingSubcategories(Set<String> set, String string) {
        String string2 = '|' + string + '|';
        for (String string3 : this.subcategories) {
            if (!('|' + string3 + '|').contains(string2)) continue;
            set.add(string3);
        }
    }
}

