/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.listener.statistics.AbstractListener;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;

@Singleton
public class BreaksListener
extends AbstractListener {
    private Set<String> oreBlocks;
    private boolean disableSilkTouchBreaks;
    private boolean disableSilkTouchOreBreaks;

    @Inject
    public BreaksListener(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager) {
        super(MultipleAchievements.BREAKS, yamlConfiguration, achievementMap, cacheManager);
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.disableSilkTouchBreaks = this.mainConfig.getBoolean("DisableSilkTouchBreaks");
        this.disableSilkTouchOreBreaks = this.mainConfig.getBoolean("DisableSilkTouchOreBreaks");
        this.oreBlocks = new HashSet<String>();
        for (String string : this.mainConfig.getStringList("OreBlocks")) {
            this.oreBlocks.add(string.toUpperCase());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        Player player = blockBreakEvent.getPlayer();
        Block block = blockBreakEvent.getBlock();
        if ((this.disableSilkTouchBreaks || this.disableSilkTouchOreBreaks) && player.getInventory().getItemInMainHand().containsEnchantment(Enchantment.SILK_TOUCH) && (this.disableSilkTouchBreaks || this.oreBlocks.contains(block.getType().name()))) {
            return;
        }
        String string = block.getType().name().toLowerCase();
        if (!player.hasPermission(this.category.toChildPermName(string))) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        this.addMatchingSubcategories(hashSet, string);
        this.updateStatisticAndAwardAchievementsIfAvailable(player, hashSet, 1);
    }
}

