/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.listener.statistics.AbstractListener;
import com.hm.achievement.utils.InventoryHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

@Singleton
public class CraftsListener
extends AbstractListener {
    @Inject
    public CraftsListener(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager) {
        super(MultipleAchievements.CRAFTS, yamlConfiguration, achievementMap, cacheManager);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCraftItem(CraftItemEvent craftItemEvent) {
        ItemStack itemStack;
        String string;
        if (!(craftItemEvent.getWhoClicked() instanceof Player) || craftItemEvent.getAction() == InventoryAction.NOTHING || craftItemEvent.getClick() == ClickType.NUMBER_KEY && craftItemEvent.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD || this.isCraftingIngotFromBlock(craftItemEvent.getRecipe())) {
            return;
        }
        Player player = (Player)craftItemEvent.getWhoClicked();
        if (!player.hasPermission(this.category.toChildPermName(string = (itemStack = craftItemEvent.getCurrentItem()).getType().name().toLowerCase()))) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        this.addMatchingSubcategories(hashSet, string);
        int n = itemStack.getAmount();
        if (craftItemEvent.isShiftClick()) {
            ItemStack[] itemStackArray;
            int n2 = craftItemEvent.getInventory().getMaxStackSize();
            for (ItemStack itemStack2 : itemStackArray = craftItemEvent.getInventory().getMatrix()) {
                int n3;
                if (itemStack2 == null || itemStack2.getType() == Material.AIR || (n3 = itemStack2.getAmount()) >= n2 || n3 <= 0) continue;
                n2 = n3;
            }
            n *= n2;
            if ((n = Math.min(n, InventoryHelper.getAvailableSpace(player, itemStack))) == 0) {
                return;
            }
        }
        this.updateStatisticAndAwardAchievementsIfAvailable(player, hashSet, n);
    }

    private boolean isCraftingIngotFromBlock(Recipe recipe) {
        ShapedRecipe shapedRecipe;
        Collection collection;
        Material material = Material.AIR;
        if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
            List list = shapelessRecipe.getIngredientList();
            if (list.size() == 1) {
                material = ((ItemStack)list.get(0)).getType();
            }
        } else if (recipe instanceof ShapedRecipe && (collection = (shapedRecipe = (ShapedRecipe)recipe).getIngredientMap().values()).size() == 1) {
            material = ((ItemStack)collection.iterator().next()).getType();
        }
        return material.name().endsWith("_BLOCK") && recipe.getResult().getType().name().endsWith("_INGOT");
    }
}

