/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.listener.statistics.AbstractListener;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

@Singleton
public class HoePlowingListener
extends AbstractListener {
    private Set<String> hoePlowableBlocks;

    @Inject
    public HoePlowingListener(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager) {
        super(NormalAchievements.HOEPLOWING, yamlConfiguration, achievementMap, cacheManager);
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.hoePlowableBlocks = new HashSet<String>();
        for (String string : this.mainConfig.getStringList("HoePlowableBlocks")) {
            this.hoePlowableBlocks.add(string.toUpperCase());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.useItemInHand() == Event.Result.DENY || playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK || !playerInteractEvent.getMaterial().name().contains("HOE") || !this.hoePlowableBlocks.contains(playerInteractEvent.getClickedBlock().getType().name()) || playerInteractEvent.getClickedBlock().getRelative(BlockFace.UP).getType() != Material.AIR) {
            return;
        }
        this.updateStatisticAndAwardAchievementsIfAvailable(playerInteractEvent.getPlayer(), 1);
    }
}

