/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.listener.statistics.AbstractListener;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.projectiles.ProjectileSource;

@Singleton
public class SnowballsListener
extends AbstractListener {
    @Inject
    public SnowballsListener(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager) {
        super(NormalAchievements.SNOWBALLS, yamlConfiguration, achievementMap, cacheManager);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent projectileLaunchEvent) {
        ProjectileSource projectileSource = projectileLaunchEvent.getEntity().getShooter();
        if (!(projectileSource instanceof Player) || !(projectileLaunchEvent.getEntity() instanceof Snowball)) {
            return;
        }
        this.updateStatisticAndAwardAchievementsIfAvailable((Player)projectileSource, 1);
    }
}

