/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.listener.statistics.AbstractListener;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.ProjectileHitEvent;

@Singleton
public class TargetsShotListener
extends AbstractListener {
    @Inject
    public TargetsShotListener(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager) {
        super(MultipleAchievements.TARGETSSHOT, yamlConfiguration, achievementMap, cacheManager);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProjectileHit(ProjectileHitEvent projectileHitEvent) {
        String string;
        if (!(projectileHitEvent.getEntity().getShooter() instanceof Player)) {
            return;
        }
        if (projectileHitEvent.getHitEntity() != null) {
            string = projectileHitEvent.getHitEntity().getType().name().toLowerCase();
        } else if (projectileHitEvent.getHitBlock() != null) {
            string = projectileHitEvent.getHitBlock().getType().name().toLowerCase();
        } else {
            return;
        }
        Player player = (Player)projectileHitEvent.getEntity().getShooter();
        if (!player.hasPermission(this.category.toChildPermName(string))) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        this.addMatchingSubcategories(hashSet, string);
        this.updateStatisticAndAwardAchievementsIfAvailable(player, hashSet, 1);
    }
}

