/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.listener.statistics.AbstractListener;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerFishEvent;

@Singleton
public class TreasuresListener
extends AbstractListener {
    private Set<String> fishableFish;

    @Inject
    public TreasuresListener(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager) {
        super(NormalAchievements.TREASURES, yamlConfiguration, achievementMap, cacheManager);
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.fishableFish = new HashSet<String>();
        for (String string : this.mainConfig.getStringList("FishableFish")) {
            this.fishableFish.add(string.toUpperCase());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerFish(PlayerFishEvent playerFishEvent) {
        if (playerFishEvent.getState() != PlayerFishEvent.State.CAUGHT_FISH || this.fishableFish.contains(((Item)playerFishEvent.getCaught()).getItemStack().getType().name())) {
            return;
        }
        this.updateStatisticAndAwardAchievementsIfAvailable(playerFishEvent.getPlayer(), 1);
    }
}

