/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.module;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.db.DatabaseUpdater;
import com.hm.achievement.db.H2DatabaseManager;
import com.hm.achievement.db.MySQLDatabaseManager;
import com.hm.achievement.db.PostgreSQLDatabaseManager;
import com.hm.achievement.db.SQLiteDatabaseManager;
import com.hm.dagger.Module;
import com.hm.dagger.Provides;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.configuration.file.YamlConfiguration;

@Module
public class DatabaseModule {
    @Provides
    @Singleton
    ExecutorService provideWriteExecutor() {
        return Executors.newCachedThreadPool();
    }

    @Provides
    @Singleton
    AbstractDatabaseManager provideSQLDatabaseManager(@Named(value="main") YamlConfiguration yamlConfiguration, Logger logger, DatabaseUpdater databaseUpdater, AdvancedAchievements advancedAchievements, ExecutorService executorService) {
        String string = advancedAchievements.getConfig().getString("DatabaseType", "sqlite");
        if ("mysql".equalsIgnoreCase(string)) {
            return new MySQLDatabaseManager(yamlConfiguration, logger, databaseUpdater, executorService);
        }
        if ("postgresql".equalsIgnoreCase(string)) {
            return new PostgreSQLDatabaseManager(yamlConfiguration, logger, databaseUpdater, executorService);
        }
        if ("h2".equalsIgnoreCase(string)) {
            return new H2DatabaseManager(yamlConfiguration, logger, databaseUpdater, advancedAchievements, executorService);
        }
        return new SQLiteDatabaseManager(yamlConfiguration, logger, databaseUpdater, advancedAchievements, executorService);
    }
}

