/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.placeholder;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.category.Category;
import com.hm.achievement.category.CommandAchievements;
import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import java.util.UUID;
import javax.inject.Inject;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class AchievementPlaceholderHook
extends PlaceholderExpansion {
    private final AdvancedAchievements advancedAchievements;
    private final CacheManager cacheManager;
    private final AchievementMap achievementMap;

    @Inject
    public AchievementPlaceholderHook(AdvancedAchievements advancedAchievements, CacheManager cacheManager, AchievementMap achievementMap) {
        this.advancedAchievements = advancedAchievements;
        this.cacheManager = cacheManager;
        this.achievementMap = achievementMap;
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(Player player, String string) {
        if ("total_achievements".equalsIgnoreCase(string)) {
            return Integer.toString(this.achievementMap.getAll().size());
        }
        if (player != null) {
            UUID uUID = player.getUniqueId();
            if ("achievements".equalsIgnoreCase(string)) {
                return Integer.toString(this.cacheManager.getPlayerAchievements(uUID).size());
            }
            if ("achievements_percentage".equalsIgnoreCase(string)) {
                return String.format("%.1f%%", 100.0 * (double)this.cacheManager.getPlayerAchievements(uUID).size() / (double)this.achievementMap.getAll().size());
            }
            if ("total_commands".equalsIgnoreCase(string)) {
                return Integer.toString(this.achievementMap.getForCategory(CommandAchievements.COMMANDS).size());
            }
            for (NormalAchievements enum_ : NormalAchievements.values()) {
                if (enum_.toString().equalsIgnoreCase(string)) {
                    long l = this.cacheManager.getAndIncrementStatisticAmount(enum_, uUID, 0);
                    return enum_ == NormalAchievements.PLAYEDTIME ? String.format("%.1f", (double)l / 3600000.0) : Long.toString(l);
                }
                if (!("total_" + enum_).equalsIgnoreCase(string)) continue;
                return Integer.toString(this.achievementMap.getForCategory(enum_).size());
            }
            for (Enum enum_ : MultipleAchievements.values()) {
                if (("total_" + enum_).equalsIgnoreCase(string)) {
                    return Integer.toString(this.achievementMap.getForCategory((Category)((Object)enum_)).size());
                }
                for (String string2 : this.achievementMap.getSubcategoriesForCategory((Category)((Object)enum_))) {
                    String string3 = enum_ + "_" + string2;
                    if (!string3.equalsIgnoreCase(string)) continue;
                    return Long.toString(this.cacheManager.getAndIncrementStatisticAmount((MultipleAchievements)enum_, string2, uUID, 0));
                }
            }
        }
        return null;
    }

    public String getIdentifier() {
        return "aach";
    }

    public String getAuthor() {
        return String.join((CharSequence)", ", this.advancedAchievements.getDescription().getAuthors());
    }

    public String getVersion() {
        return this.advancedAchievements.getDescription().getVersion();
    }
}

