/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.runnable;

import com.hm.achievement.category.Category;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.lifecycle.Cleanable;
import com.hm.achievement.utils.StatisticIncreaseHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.util.NumberConversions;

@Singleton
public class AchieveDistanceRunnable
extends StatisticIncreaseHandler
implements Cleanable,
Runnable {
    private final Map<UUID, Location> playerLocations = new HashMap<UUID, Location>();
    private final Set<Category> disabledCategories;
    private boolean configIgnoreVerticalDistance;

    @Inject
    public AchieveDistanceRunnable(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager, Set<Category> set) {
        super(yamlConfiguration, achievementMap, cacheManager);
        this.disabledCategories = set;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.configIgnoreVerticalDistance = this.mainConfig.getBoolean("IgnoreVerticalDistance");
    }

    @Override
    public void cleanPlayerData() {
        this.playerLocations.keySet().removeIf(uUID -> !Bukkit.getOfflinePlayer((UUID)uUID).isOnline());
    }

    @Override
    public void run() {
        Bukkit.getOnlinePlayers().forEach(this::validateMovementAndUpdateDistance);
    }

    public void updateLocation(UUID uUID, Location location) {
        this.playerLocations.put(uUID, location);
    }

    private void validateMovementAndUpdateDistance(Player player) {
        Location location = player.getLocation();
        Location location2 = this.playerLocations.put(player.getUniqueId(), location);
        if (location2 == null || !location2.getWorld().getUID().equals(player.getWorld().getUID())) {
            return;
        }
        int n = this.getDistanceDifference(location2, location);
        if ((long)n == 0L) {
            return;
        }
        if (player.isInsideVehicle()) {
            EntityType entityType = player.getVehicle().getType();
            if (entityType == EntityType.HORSE) {
                this.updateDistance(n, player, NormalAchievements.DISTANCEHORSE);
            } else if (entityType == EntityType.PIG) {
                this.updateDistance(n, player, NormalAchievements.DISTANCEPIG);
            } else if (entityType == EntityType.MINECART) {
                this.updateDistance(n, player, NormalAchievements.DISTANCEMINECART);
            } else if (entityType == EntityType.BOAT) {
                this.updateDistance(n, player, NormalAchievements.DISTANCEBOAT);
            } else if (entityType == EntityType.LLAMA) {
                this.updateDistance(n, player, NormalAchievements.DISTANCELLAMA);
            }
        } else if (player.isGliding()) {
            this.updateDistance(n, player, NormalAchievements.DISTANCEGLIDING);
        } else if (player.isSneaking()) {
            this.updateDistance(n, player, NormalAchievements.DISTANCESNEAKING);
        } else if (!player.isFlying()) {
            this.updateDistance(n, player, NormalAchievements.DISTANCEFOOT);
        }
    }

    private int getDistanceDifference(Location location, Location location2) {
        if (this.configIgnoreVerticalDistance) {
            double d = NumberConversions.square((double)(location.getX() - location2.getX()));
            double d2 = NumberConversions.square((double)(location.getZ() - location2.getZ()));
            return (int)Math.sqrt(d + d2);
        }
        return (int)location.distance(location2);
    }

    private void updateDistance(int n, Player player, NormalAchievements normalAchievements) {
        if (!this.shouldIncreaseBeTakenIntoAccount(player, normalAchievements) || this.disabledCategories.contains(normalAchievements)) {
            return;
        }
        long l = this.cacheManager.getAndIncrementStatisticAmount(normalAchievements, player.getUniqueId(), n);
        this.checkThresholdsAndAchievements(player, normalAchievements, l);
    }
}

