/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.runnable;

import com.earth2me.essentials.Essentials;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.utils.StatisticIncreaseHandler;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

@Singleton
public class AchievePlayTimeRunnable
extends StatisticIncreaseHandler
implements Runnable {
    private static final long MILLIS_PER_HOUR = TimeUnit.HOURS.toMillis(1L);
    private Essentials essentials;
    private long previousTimeMillis;
    private boolean configIgnoreAFKPlayedTime;

    @Inject
    public AchievePlayTimeRunnable(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager) {
        super(yamlConfiguration, achievementMap, cacheManager);
        if (Bukkit.getPluginManager().isPluginEnabled("Essentials")) {
            this.essentials = (Essentials)Bukkit.getPluginManager().getPlugin("Essentials");
        }
        this.previousTimeMillis = System.currentTimeMillis();
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.configIgnoreAFKPlayedTime = this.essentials != null && this.mainConfig.getBoolean("IgnoreAFKPlayedTime");
    }

    @Override
    public void run() {
        long l = System.currentTimeMillis();
        int n = (int)(l - this.previousTimeMillis);
        Bukkit.getOnlinePlayers().forEach(player -> this.updateTime((Player)player, n));
        this.previousTimeMillis = l;
    }

    private void updateTime(Player player, int n) {
        if (!this.shouldIncreaseBeTakenIntoAccount(player, NormalAchievements.PLAYEDTIME)) {
            return;
        }
        if (this.configIgnoreAFKPlayedTime && this.essentials.getUser(player).isAfk()) {
            return;
        }
        long l = this.cacheManager.getAndIncrementStatisticAmount(NormalAchievements.PLAYEDTIME, player.getUniqueId(), n);
        this.checkThresholdsAndAchievements(player, NormalAchievements.PLAYEDTIME, l / MILLIS_PER_HOUR);
    }
}

