/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.utils;

import java.util.Optional;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

@Singleton
public class MaterialHelper {
    private final Logger logger;

    @Inject
    public MaterialHelper(Logger logger) {
        this.logger = logger;
    }

    public Optional<Material> matchMaterial(String string, String string2) {
        return Optional.ofNullable(this.matchMaterial(string, null, string2));
    }

    public Material matchMaterial(String string, Material material, String string2) {
        if (string == null || string.isEmpty()) {
            this.logger.warning(string2 + " is missing. Please check your configuration.");
            return material;
        }
        Material material2 = Material.matchMaterial((String)string);
        if (material2 == null) {
            material2 = Material.matchMaterial((String)string, (boolean)true);
        }
        if (material2 == null) {
            this.logger.warning("Material \"" + string + "\" used in " + string2 + " is invalid. Have you spelt the name correctly and is it available for your Minecraft version?");
            material2 = material;
        }
        return material2;
    }

    public boolean isAnyPotionButWater(ItemStack itemStack) {
        if (itemStack.getType() != Material.POTION) {
            return false;
        }
        return ((PotionMeta)itemStack.getItemMeta()).getBasePotionData().getType() != PotionType.WATER;
    }
}

