/*
 * Decompiled with CFR 0.152.
 */
package com.hm.apache.commons.text;

import com.hm.apache.commons.text.TextStringBuilder;
import com.hm.apache.commons.text.matcher.StringMatcher;
import com.hm.apache.commons.text.matcher.StringMatcherFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class StringTokenizer
implements ListIterator<String>,
Cloneable {
    private static final StringTokenizer CSV_TOKENIZER_PROTOTYPE = new StringTokenizer();
    private static final StringTokenizer TSV_TOKENIZER_PROTOTYPE;
    private char[] chars;
    private String[] tokens;
    private int tokenPos;
    private StringMatcher delimMatcher = StringMatcherFactory.INSTANCE.splitMatcher();
    private StringMatcher quoteMatcher = StringMatcherFactory.INSTANCE.noneMatcher();
    private StringMatcher ignoredMatcher = StringMatcherFactory.INSTANCE.noneMatcher();
    private StringMatcher trimmerMatcher = StringMatcherFactory.INSTANCE.noneMatcher();
    private boolean emptyAsNull = false;
    private boolean ignoreEmptyTokens = true;

    private static StringTokenizer getCSVClone() {
        return (StringTokenizer)CSV_TOKENIZER_PROTOTYPE.clone();
    }

    public static StringTokenizer getCSVInstance() {
        return StringTokenizer.getCSVClone();
    }

    public static StringTokenizer getCSVInstance(String string) {
        StringTokenizer stringTokenizer = StringTokenizer.getCSVClone();
        stringTokenizer.reset(string);
        return stringTokenizer;
    }

    public static StringTokenizer getCSVInstance(char[] cArray) {
        StringTokenizer stringTokenizer = StringTokenizer.getCSVClone();
        stringTokenizer.reset(cArray);
        return stringTokenizer;
    }

    private static StringTokenizer getTSVClone() {
        return (StringTokenizer)TSV_TOKENIZER_PROTOTYPE.clone();
    }

    public static StringTokenizer getTSVInstance() {
        return StringTokenizer.getTSVClone();
    }

    public static StringTokenizer getTSVInstance(String string) {
        StringTokenizer stringTokenizer = StringTokenizer.getTSVClone();
        stringTokenizer.reset(string);
        return stringTokenizer;
    }

    public static StringTokenizer getTSVInstance(char[] cArray) {
        StringTokenizer stringTokenizer = StringTokenizer.getTSVClone();
        stringTokenizer.reset(cArray);
        return stringTokenizer;
    }

    public StringTokenizer() {
        this.chars = null;
    }

    public StringTokenizer(String string) {
        this.chars = (char[])(string != null ? string.toCharArray() : null);
    }

    public StringTokenizer(String string, char c) {
        this(string);
        this.setDelimiterChar(c);
    }

    public StringTokenizer(String string, String string2) {
        this(string);
        this.setDelimiterString(string2);
    }

    public StringTokenizer(String string, StringMatcher stringMatcher) {
        this(string);
        this.setDelimiterMatcher(stringMatcher);
    }

    public StringTokenizer(String string, char c, char c2) {
        this(string, c);
        this.setQuoteChar(c2);
    }

    public StringTokenizer(String string, StringMatcher stringMatcher, StringMatcher stringMatcher2) {
        this(string, stringMatcher);
        this.setQuoteMatcher(stringMatcher2);
    }

    public StringTokenizer(char[] cArray) {
        this.chars = (char[])(cArray == null ? null : (char[])cArray.clone());
    }

    public StringTokenizer(char[] cArray, char c) {
        this(cArray);
        this.setDelimiterChar(c);
    }

    public StringTokenizer(char[] cArray, String string) {
        this(cArray);
        this.setDelimiterString(string);
    }

    public StringTokenizer(char[] cArray, StringMatcher stringMatcher) {
        this(cArray);
        this.setDelimiterMatcher(stringMatcher);
    }

    public StringTokenizer(char[] cArray, char c, char c2) {
        this(cArray, c);
        this.setQuoteChar(c2);
    }

    public StringTokenizer(char[] cArray, StringMatcher stringMatcher, StringMatcher stringMatcher2) {
        this(cArray, stringMatcher);
        this.setQuoteMatcher(stringMatcher2);
    }

    public int size() {
        this.checkTokenized();
        return this.tokens.length;
    }

    public String nextToken() {
        if (this.hasNext()) {
            return this.tokens[this.tokenPos++];
        }
        return null;
    }

    public String previousToken() {
        if (this.hasPrevious()) {
            return this.tokens[--this.tokenPos];
        }
        return null;
    }

    public String[] getTokenArray() {
        this.checkTokenized();
        return (String[])this.tokens.clone();
    }

    public List<String> getTokenList() {
        this.checkTokenized();
        ArrayList<String> arrayList = new ArrayList<String>(this.tokens.length);
        Collections.addAll(arrayList, this.tokens);
        return arrayList;
    }

    public StringTokenizer reset() {
        this.tokenPos = 0;
        this.tokens = null;
        return this;
    }

    public StringTokenizer reset(String string) {
        this.reset();
        this.chars = (char[])(string != null ? string.toCharArray() : null);
        return this;
    }

    public StringTokenizer reset(char[] cArray) {
        this.reset();
        this.chars = (char[])(cArray != null ? (char[])cArray.clone() : null);
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkTokenized();
        return this.tokenPos < this.tokens.length;
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            return this.tokens[this.tokenPos++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.tokenPos;
    }

    @Override
    public boolean hasPrevious() {
        this.checkTokenized();
        return this.tokenPos > 0;
    }

    @Override
    public String previous() {
        if (this.hasPrevious()) {
            return this.tokens[--this.tokenPos];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int previousIndex() {
        return this.tokenPos - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is unsupported");
    }

    @Override
    public void set(String string) {
        throw new UnsupportedOperationException("set() is unsupported");
    }

    @Override
    public void add(String string) {
        throw new UnsupportedOperationException("add() is unsupported");
    }

    private void checkTokenized() {
        if (this.tokens == null) {
            if (this.chars == null) {
                List<String> list = this.tokenize(null, 0, 0);
                this.tokens = list.toArray(new String[list.size()]);
            } else {
                List<String> list = this.tokenize(this.chars, 0, this.chars.length);
                this.tokens = list.toArray(new String[list.size()]);
            }
        }
    }

    protected List<String> tokenize(char[] cArray, int n, int n2) {
        if (cArray == null || n2 == 0) {
            return Collections.emptyList();
        }
        TextStringBuilder textStringBuilder = new TextStringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = n;
        while (n3 >= 0 && n3 < n2) {
            if ((n3 = this.readNextToken(cArray, n3, n2, textStringBuilder, arrayList)) < n2) continue;
            this.addToken(arrayList, "");
        }
        return arrayList;
    }

    private void addToken(List<String> list, String string) {
        if (string == null || string.length() == 0) {
            if (this.isIgnoreEmptyTokens()) {
                return;
            }
            if (this.isEmptyTokenAsNull()) {
                string = null;
            }
        }
        list.add(string);
    }

    private int readNextToken(char[] cArray, int n, int n2, TextStringBuilder textStringBuilder, List<String> list) {
        int n3;
        while (n < n2 && (n3 = Math.max(this.getIgnoredMatcher().isMatch(cArray, n, n, n2), this.getTrimmerMatcher().isMatch(cArray, n, n, n2))) != 0 && this.getDelimiterMatcher().isMatch(cArray, n, n, n2) <= 0 && this.getQuoteMatcher().isMatch(cArray, n, n, n2) <= 0) {
            n += n3;
        }
        if (n >= n2) {
            this.addToken(list, "");
            return -1;
        }
        n3 = this.getDelimiterMatcher().isMatch(cArray, n, n, n2);
        if (n3 > 0) {
            this.addToken(list, "");
            return n + n3;
        }
        int n4 = this.getQuoteMatcher().isMatch(cArray, n, n, n2);
        if (n4 > 0) {
            return this.readWithQuotes(cArray, n + n4, n2, textStringBuilder, list, n, n4);
        }
        return this.readWithQuotes(cArray, n, n2, textStringBuilder, list, 0, 0);
    }

    private int readWithQuotes(char[] cArray, int n, int n2, TextStringBuilder textStringBuilder, List<String> list, int n3, int n4) {
        textStringBuilder.clear();
        int n5 = n;
        boolean bl = n4 > 0;
        int n6 = 0;
        while (n5 < n2) {
            if (bl) {
                if (this.isQuote(cArray, n5, n2, n3, n4)) {
                    if (this.isQuote(cArray, n5 + n4, n2, n3, n4)) {
                        textStringBuilder.append(cArray, n5, n4);
                        n5 += n4 * 2;
                        n6 = textStringBuilder.size();
                        continue;
                    }
                    bl = false;
                    n5 += n4;
                    continue;
                }
                textStringBuilder.append(cArray[n5++]);
                n6 = textStringBuilder.size();
                continue;
            }
            int n7 = this.getDelimiterMatcher().isMatch(cArray, n5, n, n2);
            if (n7 > 0) {
                this.addToken(list, textStringBuilder.substring(0, n6));
                return n5 + n7;
            }
            if (n4 > 0 && this.isQuote(cArray, n5, n2, n3, n4)) {
                bl = true;
                n5 += n4;
                continue;
            }
            int n8 = this.getIgnoredMatcher().isMatch(cArray, n5, n, n2);
            if (n8 > 0) {
                n5 += n8;
                continue;
            }
            int n9 = this.getTrimmerMatcher().isMatch(cArray, n5, n, n2);
            if (n9 > 0) {
                textStringBuilder.append(cArray, n5, n9);
                n5 += n9;
                continue;
            }
            textStringBuilder.append(cArray[n5++]);
            n6 = textStringBuilder.size();
        }
        this.addToken(list, textStringBuilder.substring(0, n6));
        return -1;
    }

    private boolean isQuote(char[] cArray, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n4; ++i) {
            if (n + i < n2 && cArray[n + i] == cArray[n3 + i]) continue;
            return false;
        }
        return true;
    }

    public StringMatcher getDelimiterMatcher() {
        return this.delimMatcher;
    }

    public StringTokenizer setDelimiterMatcher(StringMatcher stringMatcher) {
        this.delimMatcher = stringMatcher == null ? StringMatcherFactory.INSTANCE.noneMatcher() : stringMatcher;
        return this;
    }

    public StringTokenizer setDelimiterChar(char c) {
        return this.setDelimiterMatcher(StringMatcherFactory.INSTANCE.charMatcher(c));
    }

    public StringTokenizer setDelimiterString(String string) {
        return this.setDelimiterMatcher(StringMatcherFactory.INSTANCE.stringMatcher(string));
    }

    public StringMatcher getQuoteMatcher() {
        return this.quoteMatcher;
    }

    public StringTokenizer setQuoteMatcher(StringMatcher stringMatcher) {
        if (stringMatcher != null) {
            this.quoteMatcher = stringMatcher;
        }
        return this;
    }

    public StringTokenizer setQuoteChar(char c) {
        return this.setQuoteMatcher(StringMatcherFactory.INSTANCE.charMatcher(c));
    }

    public StringMatcher getIgnoredMatcher() {
        return this.ignoredMatcher;
    }

    public StringTokenizer setIgnoredMatcher(StringMatcher stringMatcher) {
        if (stringMatcher != null) {
            this.ignoredMatcher = stringMatcher;
        }
        return this;
    }

    public StringTokenizer setIgnoredChar(char c) {
        return this.setIgnoredMatcher(StringMatcherFactory.INSTANCE.charMatcher(c));
    }

    public StringMatcher getTrimmerMatcher() {
        return this.trimmerMatcher;
    }

    public StringTokenizer setTrimmerMatcher(StringMatcher stringMatcher) {
        if (stringMatcher != null) {
            this.trimmerMatcher = stringMatcher;
        }
        return this;
    }

    public boolean isEmptyTokenAsNull() {
        return this.emptyAsNull;
    }

    public StringTokenizer setEmptyTokenAsNull(boolean bl) {
        this.emptyAsNull = bl;
        return this;
    }

    public boolean isIgnoreEmptyTokens() {
        return this.ignoreEmptyTokens;
    }

    public StringTokenizer setIgnoreEmptyTokens(boolean bl) {
        this.ignoreEmptyTokens = bl;
        return this;
    }

    public String getContent() {
        if (this.chars == null) {
            return null;
        }
        return new String(this.chars);
    }

    public Object clone() {
        try {
            return this.cloneReset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    Object cloneReset() {
        StringTokenizer stringTokenizer = (StringTokenizer)super.clone();
        if (stringTokenizer.chars != null) {
            stringTokenizer.chars = (char[])stringTokenizer.chars.clone();
        }
        stringTokenizer.reset();
        return stringTokenizer;
    }

    public String toString() {
        if (this.tokens == null) {
            return "StringTokenizer[not tokenized yet]";
        }
        return "StringTokenizer" + this.getTokenList();
    }

    static {
        CSV_TOKENIZER_PROTOTYPE.setDelimiterMatcher(StringMatcherFactory.INSTANCE.commaMatcher());
        CSV_TOKENIZER_PROTOTYPE.setQuoteMatcher(StringMatcherFactory.INSTANCE.doubleQuoteMatcher());
        CSV_TOKENIZER_PROTOTYPE.setIgnoredMatcher(StringMatcherFactory.INSTANCE.noneMatcher());
        CSV_TOKENIZER_PROTOTYPE.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        CSV_TOKENIZER_PROTOTYPE.setEmptyTokenAsNull(false);
        CSV_TOKENIZER_PROTOTYPE.setIgnoreEmptyTokens(false);
        TSV_TOKENIZER_PROTOTYPE = new StringTokenizer();
        TSV_TOKENIZER_PROTOTYPE.setDelimiterMatcher(StringMatcherFactory.INSTANCE.tabMatcher());
        TSV_TOKENIZER_PROTOTYPE.setQuoteMatcher(StringMatcherFactory.INSTANCE.doubleQuoteMatcher());
        TSV_TOKENIZER_PROTOTYPE.setIgnoredMatcher(StringMatcherFactory.INSTANCE.noneMatcher());
        TSV_TOKENIZER_PROTOTYPE.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        TSV_TOKENIZER_PROTOTYPE.setEmptyTokenAsNull(false);
        TSV_TOKENIZER_PROTOTYPE.setIgnoreEmptyTokens(false);
    }
}

