/*
 * Decompiled with CFR 0.152.
 */
package com.hm.apache.commons.text;

import com.hm.apache.commons.lang3.ArrayUtils;
import com.hm.apache.commons.lang3.StringUtils;
import com.hm.apache.commons.text.Builder;
import com.hm.apache.commons.text.StringTokenizer;
import com.hm.apache.commons.text.matcher.StringMatcher;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class TextStringBuilder
implements CharSequence,
Appendable,
Serializable,
Builder<String> {
    private static final char SPACE = ' ';
    static final int CAPACITY = 32;
    private static final int EOS = -1;
    private static final int FALSE_STRING_SIZE = Boolean.FALSE.toString().length();
    private static final long serialVersionUID = 1L;
    private static final int TRUE_STRING_SIZE = Boolean.TRUE.toString().length();
    private char[] buffer;
    private String newLine;
    private String nullText;
    private int reallocations;
    private int size;

    public static TextStringBuilder wrap(char[] cArray) {
        Objects.requireNonNull(cArray, "initialBuffer");
        return new TextStringBuilder(cArray, cArray.length);
    }

    public static TextStringBuilder wrap(char[] cArray, int n) {
        return new TextStringBuilder(cArray, n);
    }

    public TextStringBuilder() {
        this(32);
    }

    private TextStringBuilder(char[] cArray, int n) {
        this.buffer = Objects.requireNonNull(cArray, "initialBuffer");
        if (n < 0 || n > cArray.length) {
            throw new IllegalArgumentException("initialBuffer.length=" + cArray.length + ", length=" + n);
        }
        this.size = n;
    }

    public TextStringBuilder(CharSequence charSequence) {
        this(StringUtils.length(charSequence) + 32);
        if (charSequence != null) {
            this.append(charSequence);
        }
    }

    public TextStringBuilder(int n) {
        this.buffer = new char[n <= 0 ? 32 : n];
    }

    public TextStringBuilder(String string) {
        this(StringUtils.length(string) + 32);
        if (string != null) {
            this.append(string);
        }
    }

    public TextStringBuilder append(boolean bl) {
        if (bl) {
            this.ensureCapacity(this.size + TRUE_STRING_SIZE);
            this.appendTrue(this.size);
        } else {
            this.ensureCapacity(this.size + FALSE_STRING_SIZE);
            this.appendFalse(this.size);
        }
        return this;
    }

    @Override
    public TextStringBuilder append(char c) {
        int n = this.length();
        this.ensureCapacity(n + 1);
        this.buffer[this.size++] = c;
        return this;
    }

    public TextStringBuilder append(char[] cArray) {
        if (cArray == null) {
            return this.appendNull();
        }
        int n = cArray.length;
        if (n > 0) {
            int n2 = this.length();
            this.ensureCapacity(n2 + n);
            System.arraycopy(cArray, 0, this.buffer, n2, n);
            this.size += n;
        }
        return this;
    }

    public TextStringBuilder append(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return this.appendNull();
        }
        if (n < 0 || n > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid startIndex: " + n2);
        }
        if (n2 < 0 || n + n2 > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + n2);
        }
        if (n2 > 0) {
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            System.arraycopy(cArray, n, this.buffer, n3, n2);
            this.size += n2;
        }
        return this;
    }

    public TextStringBuilder append(CharBuffer charBuffer) {
        return this.append(charBuffer, 0, StringUtils.length(charBuffer));
    }

    public TextStringBuilder append(CharBuffer charBuffer, int n, int n2) {
        if (charBuffer == null) {
            return this.appendNull();
        }
        if (charBuffer.hasArray()) {
            int n3 = charBuffer.remaining();
            if (n < 0 || n > n3) {
                throw new StringIndexOutOfBoundsException("startIndex must be valid");
            }
            if (n2 < 0 || n + n2 > n3) {
                throw new StringIndexOutOfBoundsException("length must be valid");
            }
            int n4 = this.length();
            this.ensureCapacity(n4 + n2);
            System.arraycopy(charBuffer.array(), charBuffer.arrayOffset() + charBuffer.position() + n, this.buffer, n4, n2);
            this.size += n2;
        } else {
            this.append(charBuffer.toString(), n, n2);
        }
        return this;
    }

    @Override
    public TextStringBuilder append(CharSequence charSequence) {
        if (charSequence == null) {
            return this.appendNull();
        }
        if (charSequence instanceof TextStringBuilder) {
            return this.append((TextStringBuilder)charSequence);
        }
        if (charSequence instanceof StringBuilder) {
            return this.append((StringBuilder)charSequence);
        }
        if (charSequence instanceof StringBuffer) {
            return this.append((StringBuffer)charSequence);
        }
        if (charSequence instanceof CharBuffer) {
            return this.append((CharBuffer)charSequence);
        }
        return this.append(charSequence.toString());
    }

    @Override
    public TextStringBuilder append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            return this.appendNull();
        }
        if (n2 <= 0) {
            throw new StringIndexOutOfBoundsException("endIndex must be valid");
        }
        if (n >= n2) {
            throw new StringIndexOutOfBoundsException("endIndex must be greater than startIndex");
        }
        return this.append(charSequence.toString(), n, n2 - n);
    }

    public TextStringBuilder append(double d) {
        return this.append(String.valueOf(d));
    }

    public TextStringBuilder append(float f) {
        return this.append(String.valueOf(f));
    }

    public TextStringBuilder append(int n) {
        return this.append(String.valueOf(n));
    }

    public TextStringBuilder append(long l) {
        return this.append(String.valueOf(l));
    }

    public TextStringBuilder append(Object object) {
        if (object == null) {
            return this.appendNull();
        }
        if (object instanceof CharSequence) {
            return this.append((CharSequence)object);
        }
        return this.append(object.toString());
    }

    public TextStringBuilder append(String string) {
        return this.append(string, 0, StringUtils.length(string));
    }

    public TextStringBuilder append(String string, int n, int n2) {
        if (string == null) {
            return this.appendNull();
        }
        if (n < 0 || n > string.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (n2 < 0 || n + n2 > string.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (n2 > 0) {
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            string.getChars(n, n + n2, this.buffer, n3);
            this.size += n2;
        }
        return this;
    }

    public TextStringBuilder append(String string, Object ... objectArray) {
        return this.append(String.format(string, objectArray));
    }

    public TextStringBuilder append(StringBuffer stringBuffer) {
        return this.append(stringBuffer, 0, StringUtils.length(stringBuffer));
    }

    public TextStringBuilder append(StringBuffer stringBuffer, int n, int n2) {
        if (stringBuffer == null) {
            return this.appendNull();
        }
        if (n < 0 || n > stringBuffer.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (n2 < 0 || n + n2 > stringBuffer.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (n2 > 0) {
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            stringBuffer.getChars(n, n + n2, this.buffer, n3);
            this.size += n2;
        }
        return this;
    }

    public TextStringBuilder append(StringBuilder stringBuilder) {
        return this.append(stringBuilder, 0, StringUtils.length(stringBuilder));
    }

    public TextStringBuilder append(StringBuilder stringBuilder, int n, int n2) {
        if (stringBuilder == null) {
            return this.appendNull();
        }
        if (n < 0 || n > stringBuilder.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (n2 < 0 || n + n2 > stringBuilder.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (n2 > 0) {
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            stringBuilder.getChars(n, n + n2, this.buffer, n3);
            this.size += n2;
        }
        return this;
    }

    public TextStringBuilder append(TextStringBuilder textStringBuilder) {
        return this.append(textStringBuilder, 0, StringUtils.length(textStringBuilder));
    }

    public TextStringBuilder append(TextStringBuilder textStringBuilder, int n, int n2) {
        if (textStringBuilder == null) {
            return this.appendNull();
        }
        if (n < 0 || n > textStringBuilder.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (n2 < 0 || n + n2 > textStringBuilder.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (n2 > 0) {
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            textStringBuilder.getChars(n, n + n2, this.buffer, n3);
            this.size += n2;
        }
        return this;
    }

    public TextStringBuilder appendAll(Iterable<?> iterable) {
        if (iterable != null) {
            for (Object obj : iterable) {
                this.append(obj);
            }
        }
        return this;
    }

    public TextStringBuilder appendAll(Iterator<?> iterator) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.append(iterator.next());
            }
        }
        return this;
    }

    public <T> TextStringBuilder appendAll(T ... TArray) {
        if (TArray != null && TArray.length > 0) {
            for (T t : TArray) {
                this.append(t);
            }
        }
        return this;
    }

    private void appendFalse(int n) {
        this.buffer[n++] = 102;
        this.buffer[n++] = 97;
        this.buffer[n++] = 108;
        this.buffer[n++] = 115;
        this.buffer[n] = 101;
        this.size += FALSE_STRING_SIZE;
    }

    public TextStringBuilder appendFixedWidthPadLeft(int n, int n2, char c) {
        return this.appendFixedWidthPadLeft(String.valueOf(n), n2, c);
    }

    public TextStringBuilder appendFixedWidthPadLeft(Object object, int n, char c) {
        if (n > 0) {
            int n2;
            String string;
            this.ensureCapacity(this.size + n);
            String string2 = string = object == null ? this.getNullText() : object.toString();
            if (string == null) {
                string = "";
            }
            if ((n2 = string.length()) >= n) {
                string.getChars(n2 - n, n2, this.buffer, this.size);
            } else {
                int n3 = n - n2;
                for (int i = 0; i < n3; ++i) {
                    this.buffer[this.size + i] = c;
                }
                string.getChars(0, n2, this.buffer, this.size + n3);
            }
            this.size += n;
        }
        return this;
    }

    public TextStringBuilder appendFixedWidthPadRight(int n, int n2, char c) {
        return this.appendFixedWidthPadRight(String.valueOf(n), n2, c);
    }

    public TextStringBuilder appendFixedWidthPadRight(Object object, int n, char c) {
        if (n > 0) {
            int n2;
            String string;
            this.ensureCapacity(this.size + n);
            String string2 = string = object == null ? this.getNullText() : object.toString();
            if (string == null) {
                string = "";
            }
            if ((n2 = string.length()) >= n) {
                string.getChars(0, n, this.buffer, this.size);
            } else {
                int n3 = n - n2;
                string.getChars(0, n2, this.buffer, this.size);
                for (int i = 0; i < n3; ++i) {
                    this.buffer[this.size + n2 + i] = c;
                }
            }
            this.size += n;
        }
        return this;
    }

    public TextStringBuilder appendln(boolean bl) {
        return this.append(bl).appendNewLine();
    }

    public TextStringBuilder appendln(char c) {
        return this.append(c).appendNewLine();
    }

    public TextStringBuilder appendln(char[] cArray) {
        return this.append(cArray).appendNewLine();
    }

    public TextStringBuilder appendln(char[] cArray, int n, int n2) {
        return this.append(cArray, n, n2).appendNewLine();
    }

    public TextStringBuilder appendln(double d) {
        return this.append(d).appendNewLine();
    }

    public TextStringBuilder appendln(float f) {
        return this.append(f).appendNewLine();
    }

    public TextStringBuilder appendln(int n) {
        return this.append(n).appendNewLine();
    }

    public TextStringBuilder appendln(long l) {
        return this.append(l).appendNewLine();
    }

    public TextStringBuilder appendln(Object object) {
        return this.append(object).appendNewLine();
    }

    public TextStringBuilder appendln(String string) {
        return this.append(string).appendNewLine();
    }

    public TextStringBuilder appendln(String string, int n, int n2) {
        return this.append(string, n, n2).appendNewLine();
    }

    public TextStringBuilder appendln(String string, Object ... objectArray) {
        return this.append(string, objectArray).appendNewLine();
    }

    public TextStringBuilder appendln(StringBuffer stringBuffer) {
        return this.append(stringBuffer).appendNewLine();
    }

    public TextStringBuilder appendln(StringBuffer stringBuffer, int n, int n2) {
        return this.append(stringBuffer, n, n2).appendNewLine();
    }

    public TextStringBuilder appendln(StringBuilder stringBuilder) {
        return this.append(stringBuilder).appendNewLine();
    }

    public TextStringBuilder appendln(StringBuilder stringBuilder, int n, int n2) {
        return this.append(stringBuilder, n, n2).appendNewLine();
    }

    public TextStringBuilder appendln(TextStringBuilder textStringBuilder) {
        return this.append(textStringBuilder).appendNewLine();
    }

    public TextStringBuilder appendln(TextStringBuilder textStringBuilder, int n, int n2) {
        return this.append(textStringBuilder, n, n2).appendNewLine();
    }

    public TextStringBuilder appendNewLine() {
        if (this.newLine == null) {
            this.append(System.lineSeparator());
            return this;
        }
        return this.append(this.newLine);
    }

    public TextStringBuilder appendNull() {
        if (this.nullText == null) {
            return this;
        }
        return this.append(this.nullText);
    }

    public TextStringBuilder appendPadding(int n, char c) {
        if (n >= 0) {
            this.ensureCapacity(this.size + n);
            for (int i = 0; i < n; ++i) {
                this.buffer[this.size++] = c;
            }
        }
        return this;
    }

    public TextStringBuilder appendSeparator(char c) {
        if (this.isNotEmpty()) {
            this.append(c);
        }
        return this;
    }

    public TextStringBuilder appendSeparator(char c, char c2) {
        if (this.isEmpty()) {
            this.append(c2);
        } else {
            this.append(c);
        }
        return this;
    }

    public TextStringBuilder appendSeparator(char c, int n) {
        if (n > 0) {
            this.append(c);
        }
        return this;
    }

    public TextStringBuilder appendSeparator(String string) {
        return this.appendSeparator(string, null);
    }

    public TextStringBuilder appendSeparator(String string, int n) {
        if (string != null && n > 0) {
            this.append(string);
        }
        return this;
    }

    public TextStringBuilder appendSeparator(String string, String string2) {
        String string3;
        String string4 = string3 = this.isEmpty() ? string2 : string;
        if (string3 != null) {
            this.append(string3);
        }
        return this;
    }

    public void appendTo(Appendable appendable) {
        if (appendable instanceof Writer) {
            ((Writer)appendable).write(this.buffer, 0, this.size);
        } else if (appendable instanceof StringBuilder) {
            ((StringBuilder)appendable).append(this.buffer, 0, this.size);
        } else if (appendable instanceof StringBuffer) {
            ((StringBuffer)appendable).append(this.buffer, 0, this.size);
        } else if (appendable instanceof CharBuffer) {
            ((CharBuffer)appendable).put(this.buffer, 0, this.size);
        } else {
            appendable.append(this);
        }
    }

    private void appendTrue(int n) {
        this.buffer[n++] = 116;
        this.buffer[n++] = 114;
        this.buffer[n++] = 117;
        this.buffer[n] = 101;
        this.size += TRUE_STRING_SIZE;
    }

    public TextStringBuilder appendWithSeparators(Iterable<?> iterable, String string) {
        if (iterable != null) {
            String string2 = Objects.toString(string, "");
            Iterator<?> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                this.append(iterator.next());
                if (!iterator.hasNext()) continue;
                this.append(string2);
            }
        }
        return this;
    }

    public TextStringBuilder appendWithSeparators(Iterator<?> iterator, String string) {
        if (iterator != null) {
            String string2 = Objects.toString(string, "");
            while (iterator.hasNext()) {
                this.append(iterator.next());
                if (!iterator.hasNext()) continue;
                this.append(string2);
            }
        }
        return this;
    }

    public TextStringBuilder appendWithSeparators(Object[] objectArray, String string) {
        if (objectArray != null && objectArray.length > 0) {
            String string2 = Objects.toString(string, "");
            this.append(objectArray[0]);
            for (int i = 1; i < objectArray.length; ++i) {
                this.append(string2);
                this.append(objectArray[i]);
            }
        }
        return this;
    }

    public Reader asReader() {
        return new TextStringBuilderReader();
    }

    public StringTokenizer asTokenizer() {
        return new TextStringBuilderTokenizer();
    }

    public Writer asWriter() {
        return new TextStringBuilderWriter();
    }

    @Override
    public String build() {
        return this.toString();
    }

    public int capacity() {
        return this.buffer.length;
    }

    @Override
    public char charAt(int n) {
        this.validateIndex(n);
        return this.buffer[n];
    }

    public TextStringBuilder clear() {
        this.size = 0;
        return this;
    }

    public boolean contains(char c) {
        char[] cArray = this.buffer;
        for (int i = 0; i < this.size; ++i) {
            if (cArray[i] != c) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String string) {
        return this.indexOf(string, 0) >= 0;
    }

    public boolean contains(StringMatcher stringMatcher) {
        return this.indexOf(stringMatcher, 0) >= 0;
    }

    public TextStringBuilder delete(int n, int n2) {
        int n3 = this.validateRange(n, n2);
        int n4 = n3 - n;
        if (n4 > 0) {
            this.deleteImpl(n, n3, n4);
        }
        return this;
    }

    public TextStringBuilder deleteAll(char c) {
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] != c) continue;
            int n = i;
            while (++i < this.size && this.buffer[i] == c) {
            }
            int n2 = i - n;
            this.deleteImpl(n, i, n2);
            i -= n2;
        }
        return this;
    }

    public TextStringBuilder deleteAll(String string) {
        int n;
        int n2 = n = string == null ? 0 : string.length();
        if (n > 0) {
            int n3 = this.indexOf(string, 0);
            while (n3 >= 0) {
                this.deleteImpl(n3, n3 + n, n);
                n3 = this.indexOf(string, n3);
            }
        }
        return this;
    }

    public TextStringBuilder deleteAll(StringMatcher stringMatcher) {
        return this.replace(stringMatcher, null, 0, this.size, -1);
    }

    public TextStringBuilder deleteCharAt(int n) {
        this.validateIndex(n);
        this.deleteImpl(n, n + 1, 1);
        return this;
    }

    public TextStringBuilder deleteFirst(char c) {
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] != c) continue;
            this.deleteImpl(i, i + 1, 1);
            break;
        }
        return this;
    }

    public TextStringBuilder deleteFirst(String string) {
        int n;
        int n2;
        int n3 = n2 = string == null ? 0 : string.length();
        if (n2 > 0 && (n = this.indexOf(string, 0)) >= 0) {
            this.deleteImpl(n, n + n2, n2);
        }
        return this;
    }

    public TextStringBuilder deleteFirst(StringMatcher stringMatcher) {
        return this.replace(stringMatcher, null, 0, this.size, 1);
    }

    private void deleteImpl(int n, int n2, int n3) {
        System.arraycopy(this.buffer, n2, this.buffer, n, this.size - n2);
        this.size -= n3;
    }

    public char drainChar(int n) {
        this.validateIndex(n);
        char c = this.buffer[n];
        this.deleteCharAt(n);
        return c;
    }

    public int drainChars(int n, int n2, char[] cArray, int n3) {
        int n4 = n2 - n;
        if (this.isEmpty() || n4 == 0 || cArray.length == 0) {
            return 0;
        }
        int n5 = Math.min(Math.min(this.size, n4), cArray.length - n3);
        this.getChars(n, n5, cArray, n3);
        this.delete(n, n5);
        return n5;
    }

    public boolean endsWith(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return true;
        }
        if (n > this.size) {
            return false;
        }
        int n2 = this.size - n;
        int n3 = 0;
        while (n3 < n) {
            if (this.buffer[n2] != string.charAt(n3)) {
                return false;
            }
            ++n3;
            ++n2;
        }
        return true;
    }

    public TextStringBuilder ensureCapacity(int n) {
        if (n > this.buffer.length) {
            this.reallocate(n * 2);
        }
        return this;
    }

    public boolean equals(Object object) {
        return object instanceof TextStringBuilder && this.equals((TextStringBuilder)object);
    }

    public boolean equals(TextStringBuilder textStringBuilder) {
        return textStringBuilder != null && Arrays.equals(this.buffer, textStringBuilder.buffer);
    }

    public boolean equalsIgnoreCase(TextStringBuilder textStringBuilder) {
        if (this == textStringBuilder) {
            return true;
        }
        if (this.size != textStringBuilder.size) {
            return false;
        }
        char[] cArray = this.buffer;
        char[] cArray2 = textStringBuilder.buffer;
        for (int i = this.size - 1; i >= 0; --i) {
            char c = cArray[i];
            char c2 = cArray2[i];
            if (c == c2 || Character.toUpperCase(c) == Character.toUpperCase(c2)) continue;
            return false;
        }
        return true;
    }

    char[] getBuffer() {
        return this.buffer;
    }

    public char[] getChars(char[] cArray) {
        int n = this.length();
        if (cArray == null || cArray.length < n) {
            cArray = new char[n];
        }
        System.arraycopy(this.buffer, 0, cArray, 0, n);
        return cArray;
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.length()) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        System.arraycopy(this.buffer, n, cArray, n3, n2 - n);
    }

    public String getNewLineText() {
        return this.newLine;
    }

    public String getNullText() {
        return this.nullText;
    }

    public int hashCode() {
        return Arrays.hashCode(this.buffer);
    }

    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(char c, int n) {
        if ((n = Math.max(0, n)) >= this.size) {
            return -1;
        }
        char[] cArray = this.buffer;
        for (int i = n; i < this.size; ++i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        n = Math.max(0, n);
        if (string == null || n >= this.size) {
            return -1;
        }
        int n2 = string.length();
        if (n2 == 1) {
            return this.indexOf(string.charAt(0), n);
        }
        if (n2 == 0) {
            return n;
        }
        if (n2 > this.size) {
            return -1;
        }
        char[] cArray = this.buffer;
        int n3 = this.size - n2 + 1;
        block0: for (int i = n; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (string.charAt(j) != cArray[i + j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public int indexOf(StringMatcher stringMatcher) {
        return this.indexOf(stringMatcher, 0);
    }

    public int indexOf(StringMatcher stringMatcher, int n) {
        n = Math.max(0, n);
        if (stringMatcher == null || n >= this.size) {
            return -1;
        }
        int n2 = this.size;
        char[] cArray = this.buffer;
        for (int i = n; i < n2; ++i) {
            if (stringMatcher.isMatch(cArray, i, n, n2) <= 0) continue;
            return i;
        }
        return -1;
    }

    public TextStringBuilder insert(int n, boolean bl) {
        this.validateIndex(n);
        if (bl) {
            this.ensureCapacity(this.size + TRUE_STRING_SIZE);
            System.arraycopy(this.buffer, n, this.buffer, n + TRUE_STRING_SIZE, this.size - n);
            this.appendTrue(n);
        } else {
            this.ensureCapacity(this.size + FALSE_STRING_SIZE);
            System.arraycopy(this.buffer, n, this.buffer, n + FALSE_STRING_SIZE, this.size - n);
            this.appendFalse(n);
        }
        return this;
    }

    public TextStringBuilder insert(int n, char c) {
        this.validateIndex(n);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.buffer, n, this.buffer, n + 1, this.size - n);
        this.buffer[n] = c;
        ++this.size;
        return this;
    }

    public TextStringBuilder insert(int n, char[] cArray) {
        this.validateIndex(n);
        if (cArray == null) {
            return this.insert(n, this.nullText);
        }
        int n2 = cArray.length;
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            System.arraycopy(this.buffer, n, this.buffer, n + n2, this.size - n);
            System.arraycopy(cArray, 0, this.buffer, n, n2);
            this.size += n2;
        }
        return this;
    }

    public TextStringBuilder insert(int n, char[] cArray, int n2, int n3) {
        this.validateIndex(n);
        if (cArray == null) {
            return this.insert(n, this.nullText);
        }
        if (n2 < 0 || n2 > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid offset: " + n2);
        }
        if (n3 < 0 || n2 + n3 > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + n3);
        }
        if (n3 > 0) {
            this.ensureCapacity(this.size + n3);
            System.arraycopy(this.buffer, n, this.buffer, n + n3, this.size - n);
            System.arraycopy(cArray, n2, this.buffer, n, n3);
            this.size += n3;
        }
        return this;
    }

    public TextStringBuilder insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public TextStringBuilder insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public TextStringBuilder insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public TextStringBuilder insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public TextStringBuilder insert(int n, Object object) {
        if (object == null) {
            return this.insert(n, this.nullText);
        }
        return this.insert(n, object.toString());
    }

    public TextStringBuilder insert(int n, String string) {
        int n2;
        this.validateIndex(n);
        if (string == null) {
            string = this.nullText;
        }
        if (string != null && (n2 = string.length()) > 0) {
            int n3 = this.size + n2;
            this.ensureCapacity(n3);
            System.arraycopy(this.buffer, n, this.buffer, n + n2, this.size - n);
            this.size = n3;
            string.getChars(0, n2, this.buffer, n);
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isNotEmpty() {
        return this.size != 0;
    }

    public boolean isReallocated() {
        return this.reallocations > 0;
    }

    public int lastIndexOf(char c) {
        return this.lastIndexOf(c, this.size - 1);
    }

    public int lastIndexOf(char c, int n) {
        int n2 = n = n >= this.size ? this.size - 1 : n;
        if (n < 0) {
            return -1;
        }
        for (int i = n; i >= 0; --i) {
            if (this.buffer[i] != c) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.size - 1);
    }

    public int lastIndexOf(String string, int n) {
        int n2 = n = n >= this.size ? this.size - 1 : n;
        if (string == null || n < 0) {
            return -1;
        }
        int n3 = string.length();
        if (n3 > 0 && n3 <= this.size) {
            if (n3 == 1) {
                return this.lastIndexOf(string.charAt(0), n);
            }
            block0: for (int i = n - n3 + 1; i >= 0; --i) {
                for (int j = 0; j < n3; ++j) {
                    if (string.charAt(j) != this.buffer[i + j]) continue block0;
                }
                return i;
            }
        } else if (n3 == 0) {
            return n;
        }
        return -1;
    }

    public int lastIndexOf(StringMatcher stringMatcher) {
        return this.lastIndexOf(stringMatcher, this.size);
    }

    public int lastIndexOf(StringMatcher stringMatcher, int n) {
        int n2 = n = n >= this.size ? this.size - 1 : n;
        if (stringMatcher == null || n < 0) {
            return -1;
        }
        char[] cArray = this.buffer;
        int n3 = n + 1;
        for (int i = n; i >= 0; --i) {
            if (stringMatcher.isMatch(cArray, i, 0, n3) <= 0) continue;
            return i;
        }
        return -1;
    }

    public String leftString(int n) {
        if (n <= 0) {
            return "";
        }
        if (n >= this.size) {
            return new String(this.buffer, 0, this.size);
        }
        return new String(this.buffer, 0, n);
    }

    @Override
    public int length() {
        return this.size;
    }

    public String midString(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 <= 0 || n >= this.size) {
            return "";
        }
        if (this.size <= n + n2) {
            return new String(this.buffer, n, this.size - n);
        }
        return new String(this.buffer, n, n2);
    }

    public TextStringBuilder minimizeCapacity() {
        if (this.buffer.length > this.size) {
            this.reallocate(this.size);
        }
        return this;
    }

    public int readFrom(CharBuffer charBuffer) {
        int n = this.size;
        int n2 = charBuffer.remaining();
        this.ensureCapacity(this.size + n2);
        charBuffer.get(this.buffer, this.size, n2);
        this.size += n2;
        return this.size - n;
    }

    public int readFrom(Readable readable) {
        if (readable instanceof Reader) {
            return this.readFrom((Reader)readable);
        }
        if (readable instanceof CharBuffer) {
            return this.readFrom((CharBuffer)readable);
        }
        int n = this.size;
        while (true) {
            this.ensureCapacity(this.size + 1);
            CharBuffer charBuffer = CharBuffer.wrap(this.buffer, this.size, this.buffer.length - this.size);
            int n2 = readable.read(charBuffer);
            if (n2 == -1) break;
            this.size += n2;
        }
        return this.size - n;
    }

    public int readFrom(Reader reader) {
        int n = this.size;
        this.ensureCapacity(this.size + 1);
        int n2 = reader.read(this.buffer, this.size, this.buffer.length - this.size);
        if (n2 == -1) {
            return -1;
        }
        do {
            this.size += n2;
            this.ensureCapacity(this.size + 1);
        } while ((n2 = reader.read(this.buffer, this.size, this.buffer.length - this.size)) != -1);
        return this.size - n;
    }

    public int readFrom(Reader reader, int n) {
        if (n <= 0) {
            return 0;
        }
        int n2 = this.size;
        this.ensureCapacity(this.size + n);
        int n3 = n;
        int n4 = reader.read(this.buffer, this.size, n3);
        if (n4 == -1) {
            return -1;
        }
        do {
            this.size += n4;
            n4 = reader.read(this.buffer, this.size, n3 -= n4);
        } while (n3 > 0 && n4 != -1);
        return this.size - n2;
    }

    private void reallocate(int n) {
        this.buffer = Arrays.copyOf(this.buffer, n);
        ++this.reallocations;
    }

    public TextStringBuilder replace(int n, int n2, String string) {
        n2 = this.validateRange(n, n2);
        int n3 = string == null ? 0 : string.length();
        this.replaceImpl(n, n2, n2 - n, string, n3);
        return this;
    }

    public TextStringBuilder replace(StringMatcher stringMatcher, String string, int n, int n2, int n3) {
        n2 = this.validateRange(n, n2);
        return this.replaceImpl(stringMatcher, string, n, n2, n3);
    }

    public TextStringBuilder replaceAll(char c, char c2) {
        if (c != c2) {
            for (int i = 0; i < this.size; ++i) {
                if (this.buffer[i] != c) continue;
                this.buffer[i] = c2;
            }
        }
        return this;
    }

    public TextStringBuilder replaceAll(String string, String string2) {
        int n;
        int n2 = n = string == null ? 0 : string.length();
        if (n > 0) {
            int n3 = string2 == null ? 0 : string2.length();
            int n4 = this.indexOf(string, 0);
            while (n4 >= 0) {
                this.replaceImpl(n4, n4 + n, n, string2, n3);
                n4 = this.indexOf(string, n4 + n3);
            }
        }
        return this;
    }

    public TextStringBuilder replaceAll(StringMatcher stringMatcher, String string) {
        return this.replace(stringMatcher, string, 0, this.size, -1);
    }

    public TextStringBuilder replaceFirst(char c, char c2) {
        if (c != c2) {
            for (int i = 0; i < this.size; ++i) {
                if (this.buffer[i] != c) continue;
                this.buffer[i] = c2;
                break;
            }
        }
        return this;
    }

    public TextStringBuilder replaceFirst(String string, String string2) {
        int n;
        int n2;
        int n3 = n2 = string == null ? 0 : string.length();
        if (n2 > 0 && (n = this.indexOf(string, 0)) >= 0) {
            int n4 = string2 == null ? 0 : string2.length();
            this.replaceImpl(n, n + n2, n2, string2, n4);
        }
        return this;
    }

    public TextStringBuilder replaceFirst(StringMatcher stringMatcher, String string) {
        return this.replace(stringMatcher, string, 0, this.size, 1);
    }

    private void replaceImpl(int n, int n2, int n3, String string, int n4) {
        int n5 = this.size - n3 + n4;
        if (n4 != n3) {
            this.ensureCapacity(n5);
            System.arraycopy(this.buffer, n2, this.buffer, n + n4, this.size - n2);
            this.size = n5;
        }
        if (n4 > 0) {
            string.getChars(0, n4, this.buffer, n);
        }
    }

    private TextStringBuilder replaceImpl(StringMatcher stringMatcher, String string, int n, int n2, int n3) {
        if (stringMatcher == null || this.size == 0) {
            return this;
        }
        int n4 = string == null ? 0 : string.length();
        for (int i = n; i < n2 && n3 != 0; ++i) {
            char[] cArray = this.buffer;
            int n5 = stringMatcher.isMatch(cArray, i, n, n2);
            if (n5 <= 0) continue;
            this.replaceImpl(i, i + n5, n5, string, n4);
            n2 = n2 - n5 + n4;
            i = i + n4 - 1;
            if (n3 <= 0) continue;
            --n3;
        }
        return this;
    }

    public TextStringBuilder reverse() {
        if (this.size == 0) {
            return this;
        }
        int n = this.size / 2;
        char[] cArray = this.buffer;
        int n2 = 0;
        int n3 = this.size - 1;
        while (n2 < n) {
            char c = cArray[n2];
            cArray[n2] = cArray[n3];
            cArray[n3] = c;
            ++n2;
            --n3;
        }
        return this;
    }

    public String rightString(int n) {
        if (n <= 0) {
            return "";
        }
        if (n >= this.size) {
            return new String(this.buffer, 0, this.size);
        }
        return new String(this.buffer, this.size - n, n);
    }

    public TextStringBuilder set(CharSequence charSequence) {
        this.clear();
        this.append(charSequence);
        return this;
    }

    public TextStringBuilder setCharAt(int n, char c) {
        this.validateIndex(n);
        this.buffer[n] = c;
        return this;
    }

    public TextStringBuilder setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n < this.size) {
            this.size = n;
        } else if (n > this.size) {
            this.ensureCapacity(n);
            int n2 = this.size;
            int n3 = n;
            this.size = n;
            Arrays.fill(this.buffer, n2, n3, '\u0000');
        }
        return this;
    }

    public TextStringBuilder setNewLineText(String string) {
        this.newLine = string;
        return this;
    }

    public TextStringBuilder setNullText(String string) {
        if (string != null && string.isEmpty()) {
            string = null;
        }
        this.nullText = string;
        return this;
    }

    public int size() {
        return this.size;
    }

    public boolean startsWith(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return true;
        }
        if (n > this.size) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.buffer[i] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.size) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        return this.substring(n, n2);
    }

    public String substring(int n) {
        return this.substring(n, this.size);
    }

    public String substring(int n, int n2) {
        n2 = this.validateRange(n, n2);
        return new String(this.buffer, n, n2 - n);
    }

    public char[] toCharArray() {
        return this.size == 0 ? ArrayUtils.EMPTY_CHAR_ARRAY : Arrays.copyOf(this.buffer, this.size);
    }

    public char[] toCharArray(int n, int n2) {
        int n3 = (n2 = this.validateRange(n, n2)) - n;
        return n3 == 0 ? ArrayUtils.EMPTY_CHAR_ARRAY : Arrays.copyOfRange(this.buffer, n, n2);
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.size);
    }

    public StringBuffer toStringBuffer() {
        return new StringBuffer(this.size).append(this.buffer, 0, this.size);
    }

    public StringBuilder toStringBuilder() {
        return new StringBuilder(this.size).append(this.buffer, 0, this.size);
    }

    public TextStringBuilder trim() {
        int n;
        if (this.size == 0) {
            return this;
        }
        int n2 = this.size;
        char[] cArray = this.buffer;
        for (n = 0; n < n2 && cArray[n] <= ' '; ++n) {
        }
        while (n < n2 && cArray[n2 - 1] <= ' ') {
            --n2;
        }
        if (n2 < this.size) {
            this.delete(n2, this.size);
        }
        if (n > 0) {
            this.delete(0, n);
        }
        return this;
    }

    protected void validateIndex(int n) {
        if (n < 0 || n >= this.size) {
            throw new StringIndexOutOfBoundsException(n);
        }
    }

    protected int validateRange(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.size) {
            n2 = this.size;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        return n2;
    }

    class TextStringBuilderWriter
    extends Writer {
        TextStringBuilderWriter() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] cArray) {
            TextStringBuilder.this.append(cArray);
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            TextStringBuilder.this.append(cArray, n, n2);
        }

        @Override
        public void write(int n) {
            TextStringBuilder.this.append((char)n);
        }

        @Override
        public void write(String string) {
            TextStringBuilder.this.append(string);
        }

        @Override
        public void write(String string, int n, int n2) {
            TextStringBuilder.this.append(string, n, n2);
        }
    }

    class TextStringBuilderTokenizer
    extends StringTokenizer {
        TextStringBuilderTokenizer() {
        }

        @Override
        public String getContent() {
            String string = super.getContent();
            if (string == null) {
                return TextStringBuilder.this.toString();
            }
            return string;
        }

        @Override
        protected List<String> tokenize(char[] cArray, int n, int n2) {
            if (cArray == null) {
                return super.tokenize(TextStringBuilder.this.getBuffer(), 0, TextStringBuilder.this.size());
            }
            return super.tokenize(cArray, n, n2);
        }
    }

    class TextStringBuilderReader
    extends Reader {
        private int mark;
        private int pos;

        TextStringBuilderReader() {
        }

        @Override
        public void close() {
        }

        @Override
        public void mark(int n) {
            this.mark = this.pos;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read() {
            if (!this.ready()) {
                return -1;
            }
            return TextStringBuilder.this.charAt(this.pos++);
        }

        @Override
        public int read(char[] cArray, int n, int n2) {
            if (n < 0 || n2 < 0 || n > cArray.length || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.pos >= TextStringBuilder.this.size()) {
                return -1;
            }
            if (this.pos + n2 > TextStringBuilder.this.size()) {
                n2 = TextStringBuilder.this.size() - this.pos;
            }
            TextStringBuilder.this.getChars(this.pos, this.pos + n2, cArray, n);
            this.pos += n2;
            return n2;
        }

        @Override
        public boolean ready() {
            return this.pos < TextStringBuilder.this.size();
        }

        @Override
        public void reset() {
            this.pos = this.mark;
        }

        @Override
        public long skip(long l) {
            if ((long)this.pos + l > (long)TextStringBuilder.this.size()) {
                l = TextStringBuilder.this.size() - this.pos;
            }
            if (l < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + l);
            return l;
        }
    }
}

