/*
 * Decompiled with CFR 0.152.
 */
package com.hm.apache.commons.text;

import com.hm.apache.commons.lang3.ArrayUtils;
import com.hm.apache.commons.lang3.StringUtils;
import com.hm.apache.commons.lang3.Validate;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WordUtils {
    public static String wrap(String string, int n) {
        return WordUtils.wrap(string, n, null, false);
    }

    public static String wrap(String string, int n, String string2, boolean bl) {
        return WordUtils.wrap(string, n, string2, bl, " ");
    }

    public static String wrap(String string, int n, String string2, boolean bl, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = System.lineSeparator();
        }
        if (n < 1) {
            n = 1;
        }
        if (StringUtils.isBlank(string3)) {
            string3 = " ";
        }
        Pattern pattern = Pattern.compile(string3);
        int n2 = string.length();
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder(n2 + 32);
        int n4 = -1;
        while (n3 < n2) {
            int n5 = -1;
            Matcher matcher = pattern.matcher(string.substring(n3, Math.min((int)Math.min(Integer.MAX_VALUE, (long)(n3 + n) + 1L), n2)));
            if (matcher.find()) {
                if (matcher.start() == 0) {
                    n4 = matcher.end() - matcher.start();
                    if (n4 != 0) {
                        n3 += matcher.end();
                        continue;
                    }
                    ++n3;
                }
                n5 = matcher.start() + n3;
            }
            if (n2 - n3 <= n) break;
            while (matcher.find()) {
                n5 = matcher.start() + n3;
            }
            if (n5 >= n3) {
                stringBuilder.append(string, n3, n5);
                stringBuilder.append(string2);
                n3 = n5 + 1;
                continue;
            }
            if (bl) {
                if (n4 == 0) {
                    --n3;
                }
                stringBuilder.append(string, n3, n + n3);
                stringBuilder.append(string2);
                n3 += n;
                n4 = -1;
                continue;
            }
            matcher = pattern.matcher(string.substring(n3 + n));
            if (matcher.find()) {
                n4 = matcher.end() - matcher.start();
                n5 = matcher.start() + n3 + n;
            }
            if (n5 >= 0) {
                if (n4 == 0 && n3 != 0) {
                    --n3;
                }
                stringBuilder.append(string, n3, n5);
                stringBuilder.append(string2);
                n3 = n5 + 1;
                continue;
            }
            if (n4 == 0 && n3 != 0) {
                --n3;
            }
            stringBuilder.append(string, n3, string.length());
            n3 = n2;
            n4 = -1;
        }
        if (n4 == 0 && n3 < n2) {
            --n3;
        }
        stringBuilder.append(string, n3, string.length());
        return stringBuilder.toString();
    }

    public static String capitalize(String string) {
        return WordUtils.capitalize(string, null);
    }

    public static String capitalize(String string, char ... cArray) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        Set<Integer> set = WordUtils.generateDelimiterSet(cArray);
        int n = string.length();
        int[] nArray = new int[n];
        int n2 = 0;
        boolean bl = true;
        int n3 = 0;
        while (n3 < n) {
            int n4 = string.codePointAt(n3);
            if (set.contains(n4)) {
                bl = true;
                nArray[n2++] = n4;
                n3 += Character.charCount(n4);
                continue;
            }
            if (bl) {
                int n5 = Character.toTitleCase(n4);
                nArray[n2++] = n5;
                n3 += Character.charCount(n5);
                bl = false;
                continue;
            }
            nArray[n2++] = n4;
            n3 += Character.charCount(n4);
        }
        return new String(nArray, 0, n2);
    }

    public static String capitalizeFully(String string) {
        return WordUtils.capitalizeFully(string, null);
    }

    public static String capitalizeFully(String string, char ... cArray) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        string = string.toLowerCase();
        return WordUtils.capitalize(string, cArray);
    }

    public static String uncapitalize(String string) {
        return WordUtils.uncapitalize(string, null);
    }

    public static String uncapitalize(String string, char ... cArray) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        Set<Integer> set = WordUtils.generateDelimiterSet(cArray);
        int n = string.length();
        int[] nArray = new int[n];
        int n2 = 0;
        boolean bl = true;
        int n3 = 0;
        while (n3 < n) {
            int n4 = string.codePointAt(n3);
            if (set.contains(n4)) {
                bl = true;
                nArray[n2++] = n4;
                n3 += Character.charCount(n4);
                continue;
            }
            if (bl) {
                int n5 = Character.toLowerCase(n4);
                nArray[n2++] = n5;
                n3 += Character.charCount(n5);
                bl = false;
                continue;
            }
            nArray[n2++] = n4;
            n3 += Character.charCount(n4);
        }
        return new String(nArray, 0, n2);
    }

    public static String swapCase(String string) {
        int n;
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        int n2 = string.length();
        int[] nArray = new int[n2];
        int n3 = 0;
        boolean bl = true;
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            int n4 = string.codePointAt(i);
            if (Character.isUpperCase(n4) || Character.isTitleCase(n4)) {
                n = Character.toLowerCase(n4);
                bl = false;
            } else if (Character.isLowerCase(n4)) {
                if (bl) {
                    n = Character.toTitleCase(n4);
                    bl = false;
                } else {
                    n = Character.toUpperCase(n4);
                }
            } else {
                bl = Character.isWhitespace(n4);
                n = n4;
            }
            nArray[n3++] = n;
        }
        return new String(nArray, 0, n3);
    }

    public static String initials(String string) {
        return WordUtils.initials(string, null);
    }

    public static String initials(String string, char ... cArray) {
        int n;
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (cArray != null && cArray.length == 0) {
            return "";
        }
        Set<Integer> set = WordUtils.generateDelimiterSet(cArray);
        int n2 = string.length();
        int[] nArray = new int[n2 / 2 + 1];
        int n3 = 0;
        boolean bl = true;
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (set.contains(n) || cArray == null && Character.isWhitespace(n)) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            nArray[n3++] = n;
            bl = false;
        }
        return new String(nArray, 0, n3);
    }

    public static boolean containsAllWords(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (StringUtils.isEmpty(charSequence) || ArrayUtils.isEmpty(charSequenceArray)) {
            return false;
        }
        for (CharSequence charSequence2 : charSequenceArray) {
            if (StringUtils.isBlank(charSequence2)) {
                return false;
            }
            Pattern pattern = Pattern.compile(".*\\b" + charSequence2 + "\\b.*");
            if (pattern.matcher(charSequence).matches()) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean isDelimiter(char c, char[] cArray) {
        if (cArray == null) {
            return Character.isWhitespace(c);
        }
        for (char c2 : cArray) {
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isDelimiter(int n, char[] cArray) {
        if (cArray == null) {
            return Character.isWhitespace(n);
        }
        for (int i = 0; i < cArray.length; ++i) {
            int n2 = Character.codePointAt(cArray, i);
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    public static String abbreviate(String string, int n, int n2, String string2) {
        Validate.isTrue(n2 >= -1, "upper value cannot be less than -1", new Object[0]);
        Validate.isTrue(n2 >= n || n2 == -1, "upper value is less than lower value", new Object[0]);
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (n > string.length()) {
            n = string.length();
        }
        if (n2 == -1 || n2 > string.length()) {
            n2 = string.length();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = StringUtils.indexOf((CharSequence)string, " ", n);
        if (n3 == -1) {
            stringBuilder.append(string, 0, n2);
            if (n2 != string.length()) {
                stringBuilder.append(StringUtils.defaultString(string2));
            }
        } else if (n3 > n2) {
            stringBuilder.append(string, 0, n2);
            stringBuilder.append(StringUtils.defaultString(string2));
        } else {
            stringBuilder.append(string, 0, n3);
            stringBuilder.append(StringUtils.defaultString(string2));
        }
        return stringBuilder.toString();
    }

    private static Set<Integer> generateDelimiterSet(char[] cArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (cArray == null || cArray.length == 0) {
            if (cArray == null) {
                hashSet.add(Character.codePointAt(new char[]{' '}, 0));
            }
            return hashSet;
        }
        for (int i = 0; i < cArray.length; ++i) {
            hashSet.add(Character.codePointAt(cArray, i));
        }
        return hashSet;
    }
}

