/*
 * Decompiled with CFR 0.152.
 */
package com.hm.apache.commons.text.matcher;

import com.hm.apache.commons.text.matcher.StringMatcher;
import java.util.Arrays;

abstract class AbstractStringMatcher
implements StringMatcher {
    protected AbstractStringMatcher() {
    }

    static final class TrimMatcher
    extends AbstractStringMatcher {
        private static final int SPACE_INT = 32;

        TrimMatcher() {
        }

        @Override
        public int isMatch(char[] cArray, int n, int n2, int n3) {
            return cArray[n] <= ' ' ? 1 : 0;
        }

        @Override
        public int isMatch(CharSequence charSequence, int n, int n2, int n3) {
            return charSequence.charAt(n) <= ' ' ? 1 : 0;
        }

        @Override
        public int size() {
            return 1;
        }
    }

    static final class NoneMatcher
    extends AbstractStringMatcher {
        NoneMatcher() {
        }

        @Override
        public int isMatch(char[] cArray, int n, int n2, int n3) {
            return 0;
        }

        @Override
        public int isMatch(CharSequence charSequence, int n, int n2, int n3) {
            return 0;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    static final class CharSetMatcher
    extends AbstractStringMatcher {
        private final char[] chars;

        CharSetMatcher(char[] cArray) {
            this.chars = (char[])cArray.clone();
            Arrays.sort(this.chars);
        }

        @Override
        public int isMatch(char[] cArray, int n, int n2, int n3) {
            return Arrays.binarySearch(this.chars, cArray[n]) >= 0 ? 1 : 0;
        }

        @Override
        public int isMatch(CharSequence charSequence, int n, int n2, int n3) {
            return Arrays.binarySearch(this.chars, charSequence.charAt(n)) >= 0 ? 1 : 0;
        }

        @Override
        public int size() {
            return 1;
        }

        public String toString() {
            return super.toString() + Arrays.toString(this.chars);
        }
    }

    static final class CharMatcher
    extends AbstractStringMatcher {
        private final char ch;

        CharMatcher(char c) {
            this.ch = c;
        }

        @Override
        public int isMatch(char[] cArray, int n, int n2, int n3) {
            return this.ch == cArray[n] ? 1 : 0;
        }

        @Override
        public int isMatch(CharSequence charSequence, int n, int n2, int n3) {
            return this.ch == charSequence.charAt(n) ? 1 : 0;
        }

        @Override
        public int size() {
            return 1;
        }

        public String toString() {
            return super.toString() + "['" + this.ch + "']";
        }
    }

    static final class CharArrayMatcher
    extends AbstractStringMatcher {
        private final char[] chars;
        private final String string;

        CharArrayMatcher(char ... cArray) {
            this.string = String.valueOf(cArray);
            this.chars = (char[])cArray.clone();
        }

        @Override
        public int isMatch(char[] cArray, int n, int n2, int n3) {
            int n4 = this.size();
            if (n + n4 > n3) {
                return 0;
            }
            int n5 = n;
            int n6 = 0;
            while (n6 < n4) {
                if (this.chars[n6] != cArray[n5]) {
                    return 0;
                }
                ++n6;
                ++n5;
            }
            return n4;
        }

        @Override
        public int isMatch(CharSequence charSequence, int n, int n2, int n3) {
            int n4 = this.size();
            if (n + n4 > n3) {
                return 0;
            }
            int n5 = n;
            int n6 = 0;
            while (n6 < n4) {
                if (this.chars[n6] != charSequence.charAt(n5)) {
                    return 0;
                }
                ++n6;
                ++n5;
            }
            return n4;
        }

        @Override
        public int size() {
            return this.chars.length;
        }

        public String toString() {
            return super.toString() + "[\"" + this.string + "\"]";
        }
    }

    static final class AndStringMatcher
    extends AbstractStringMatcher {
        private final StringMatcher[] stringMatchers;

        AndStringMatcher(StringMatcher ... stringMatcherArray) {
            this.stringMatchers = (StringMatcher[])stringMatcherArray.clone();
        }

        @Override
        public int isMatch(char[] cArray, int n, int n2, int n3) {
            int n4 = 0;
            int n5 = n;
            for (StringMatcher stringMatcher : this.stringMatchers) {
                if (stringMatcher == null) continue;
                int n6 = stringMatcher.isMatch(cArray, n5, n2, n3);
                if (n6 == 0) {
                    return 0;
                }
                n4 += n6;
                n5 += n6;
            }
            return n4;
        }

        @Override
        public int isMatch(CharSequence charSequence, int n, int n2, int n3) {
            int n4 = 0;
            int n5 = n;
            for (StringMatcher stringMatcher : this.stringMatchers) {
                if (stringMatcher == null) continue;
                int n6 = stringMatcher.isMatch(charSequence, n5, n2, n3);
                if (n6 == 0) {
                    return 0;
                }
                n4 += n6;
                n5 += n6;
            }
            return n4;
        }

        @Override
        public int size() {
            int n = 0;
            for (StringMatcher stringMatcher : this.stringMatchers) {
                if (stringMatcher == null) continue;
                n += stringMatcher.size();
            }
            return n;
        }
    }
}

