/*
 * Decompiled with CFR 0.152.
 */
package com.hm.apache.commons.text.matcher;

import com.hm.apache.commons.lang3.ArrayUtils;
import com.hm.apache.commons.lang3.StringUtils;
import com.hm.apache.commons.text.matcher.AbstractStringMatcher;
import com.hm.apache.commons.text.matcher.StringMatcher;

public final class StringMatcherFactory {
    private static final AbstractStringMatcher.CharMatcher COMMA_MATCHER = new AbstractStringMatcher.CharMatcher(',');
    private static final AbstractStringMatcher.CharMatcher DOUBLE_QUOTE_MATCHER = new AbstractStringMatcher.CharMatcher('\"');
    public static final StringMatcherFactory INSTANCE = new StringMatcherFactory();
    private static final AbstractStringMatcher.NoneMatcher NONE_MATCHER = new AbstractStringMatcher.NoneMatcher();
    private static final AbstractStringMatcher.CharSetMatcher QUOTE_MATCHER = new AbstractStringMatcher.CharSetMatcher("'\"".toCharArray());
    private static final AbstractStringMatcher.CharMatcher SINGLE_QUOTE_MATCHER = new AbstractStringMatcher.CharMatcher('\'');
    private static final AbstractStringMatcher.CharMatcher SPACE_MATCHER = new AbstractStringMatcher.CharMatcher(' ');
    private static final AbstractStringMatcher.CharSetMatcher SPLIT_MATCHER = new AbstractStringMatcher.CharSetMatcher(" \t\n\r\f".toCharArray());
    private static final AbstractStringMatcher.CharMatcher TAB_MATCHER = new AbstractStringMatcher.CharMatcher('\t');
    private static final AbstractStringMatcher.TrimMatcher TRIM_MATCHER = new AbstractStringMatcher.TrimMatcher();

    private StringMatcherFactory() {
    }

    public StringMatcher andMatcher(StringMatcher ... stringMatcherArray) {
        int n = ArrayUtils.getLength(stringMatcherArray);
        if (n == 0) {
            return NONE_MATCHER;
        }
        if (n == 1) {
            return stringMatcherArray[0];
        }
        return new AbstractStringMatcher.AndStringMatcher(stringMatcherArray);
    }

    public StringMatcher charMatcher(char c) {
        return new AbstractStringMatcher.CharMatcher(c);
    }

    public StringMatcher charSetMatcher(char ... cArray) {
        int n = ArrayUtils.getLength(cArray);
        if (n == 0) {
            return NONE_MATCHER;
        }
        if (n == 1) {
            return new AbstractStringMatcher.CharMatcher(cArray[0]);
        }
        return new AbstractStringMatcher.CharSetMatcher(cArray);
    }

    public StringMatcher charSetMatcher(String string) {
        int n = StringUtils.length(string);
        if (n == 0) {
            return NONE_MATCHER;
        }
        if (n == 1) {
            return new AbstractStringMatcher.CharMatcher(string.charAt(0));
        }
        return new AbstractStringMatcher.CharSetMatcher(string.toCharArray());
    }

    public StringMatcher commaMatcher() {
        return COMMA_MATCHER;
    }

    public StringMatcher doubleQuoteMatcher() {
        return DOUBLE_QUOTE_MATCHER;
    }

    public StringMatcher noneMatcher() {
        return NONE_MATCHER;
    }

    public StringMatcher quoteMatcher() {
        return QUOTE_MATCHER;
    }

    public StringMatcher singleQuoteMatcher() {
        return SINGLE_QUOTE_MATCHER;
    }

    public StringMatcher spaceMatcher() {
        return SPACE_MATCHER;
    }

    public StringMatcher splitMatcher() {
        return SPLIT_MATCHER;
    }

    public StringMatcher stringMatcher(char ... cArray) {
        int n = ArrayUtils.getLength(cArray);
        return n == 0 ? NONE_MATCHER : (n == 1 ? new AbstractStringMatcher.CharMatcher(cArray[0]) : new AbstractStringMatcher.CharArrayMatcher(cArray));
    }

    public StringMatcher stringMatcher(String string) {
        return StringUtils.isEmpty(string) ? NONE_MATCHER : this.stringMatcher(string.toCharArray());
    }

    public StringMatcher tabMatcher() {
        return TAB_MATCHER;
    }

    public StringMatcher trimMatcher() {
        return TRIM_MATCHER;
    }
}

