/*
 * Decompiled with CFR 0.152.
 */
package com.hm.apache.commons.text.similarity;

import com.hm.apache.commons.text.similarity.EditDistance;
import java.util.Arrays;

public class LevenshteinDistance
implements EditDistance<Integer> {
    private static final LevenshteinDistance DEFAULT_INSTANCE = new LevenshteinDistance();
    private final Integer threshold;

    public LevenshteinDistance() {
        this(null);
    }

    public LevenshteinDistance(Integer n) {
        if (n != null && n < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        this.threshold = n;
    }

    @Override
    public Integer apply(CharSequence charSequence, CharSequence charSequence2) {
        if (this.threshold != null) {
            return LevenshteinDistance.limitedCompare(charSequence, charSequence2, this.threshold);
        }
        return LevenshteinDistance.unlimitedCompare(charSequence, charSequence2);
    }

    public static LevenshteinDistance getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    private static int limitedCompare(CharSequence charSequence, CharSequence charSequence2, int n) {
        int n2;
        Object object;
        if (charSequence == null || charSequence2 == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n3 = charSequence.length();
        int n4 = charSequence2.length();
        if (n3 == 0) {
            return n4 <= n ? n4 : -1;
        }
        if (n4 == 0) {
            return n3 <= n ? n3 : -1;
        }
        if (n3 > n4) {
            object = charSequence;
            charSequence = charSequence2;
            charSequence2 = object;
            n3 = n4;
            n4 = charSequence2.length();
        }
        if (n4 - n3 > n) {
            return -1;
        }
        object = new int[n3 + 1];
        Object object2 = new int[n3 + 1];
        int n5 = Math.min(n3, n) + 1;
        for (n2 = 0; n2 < n5; ++n2) {
            object[n2] = n2;
        }
        Arrays.fill((int[])object, n5, ((Object)object).length, Integer.MAX_VALUE);
        Arrays.fill(object2, Integer.MAX_VALUE);
        for (n2 = 1; n2 <= n4; ++n2) {
            int n6;
            char c = charSequence2.charAt(n2 - 1);
            object2[0] = n2;
            int n7 = Math.max(1, n2 - n);
            int n8 = n6 = n2 > Integer.MAX_VALUE - n ? n3 : Math.min(n3, n2 + n);
            if (n7 > 1) {
                object2[n7 - 1] = Integer.MAX_VALUE;
            }
            for (int i = n7; i <= n6; ++i) {
                object2[i] = charSequence.charAt(i - 1) == c ? (int)object[i - 1] : 1 + Math.min(Math.min(object2[i - 1], (int)object[i]), (int)object[i - 1]);
            }
            Object object3 = object;
            object = object2;
            object2 = object3;
        }
        if (object[n3] <= n) {
            return (int)object[n3];
        }
        return -1;
    }

    private static int unlimitedCompare(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        Object object;
        if (charSequence == null || charSequence2 == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        int n2 = charSequence.length();
        int n3 = charSequence2.length();
        if (n2 == 0) {
            return n3;
        }
        if (n3 == 0) {
            return n2;
        }
        if (n2 > n3) {
            object = charSequence;
            charSequence = charSequence2;
            charSequence2 = object;
            n2 = n3;
            n3 = charSequence2.length();
        }
        object = new int[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            object[n] = n;
        }
        for (int i = 1; i <= n3; ++i) {
            Object object2 = object[0];
            char c = charSequence2.charAt(i - 1);
            object[0] = i;
            for (n = 1; n <= n2; ++n) {
                Object object3 = object[n];
                boolean bl = charSequence.charAt(n - 1) != c;
                object[n] = Math.min(Math.min((int)(object[n - 1] + true), (int)(object[n] + true)), (int)(object2 + bl));
                object2 = object3;
            }
        }
        return (int)object[n2];
    }
}

