/*
 * Decompiled with CFR 0.152.
 */
package com.hm.apache.commons.text.translate;

import com.hm.apache.commons.lang3.StringUtils;
import com.hm.apache.commons.text.translate.SinglePassTranslator;
import java.io.Writer;

public final class CsvTranslators {
    private static final char CSV_DELIMITER = ',';
    private static final char CSV_QUOTE = '\"';
    private static final String CSV_QUOTE_STR = String.valueOf('\"');
    private static final String CSV_ESCAPED_QUOTE_STR = CSV_QUOTE_STR + CSV_QUOTE_STR;
    private static final char[] CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};

    private CsvTranslators() {
    }

    public static class CsvUnescaper
    extends SinglePassTranslator {
        @Override
        void translateWhole(CharSequence charSequence, Writer writer) {
            if (charSequence.charAt(0) != '\"' || charSequence.charAt(charSequence.length() - 1) != '\"') {
                writer.write(charSequence.toString());
                return;
            }
            String string = charSequence.subSequence(1, charSequence.length() - 1).toString();
            if (StringUtils.containsAny((CharSequence)string, CSV_SEARCH_CHARS)) {
                writer.write(StringUtils.replace(string, CSV_ESCAPED_QUOTE_STR, CSV_QUOTE_STR));
            } else {
                writer.write(string);
            }
        }
    }

    public static class CsvEscaper
    extends SinglePassTranslator {
        @Override
        void translateWhole(CharSequence charSequence, Writer writer) {
            String string = charSequence.toString();
            if (StringUtils.containsNone((CharSequence)string, CSV_SEARCH_CHARS)) {
                writer.write(string);
            } else {
                writer.write(34);
                writer.write(StringUtils.replace(string, CSV_QUOTE_STR, CSV_ESCAPED_QUOTE_STR));
                writer.write(34);
            }
        }
    }
}

