/*
 * Decompiled with CFR 0.152.
 */
package com.hm.apache.commons.text.translate;

import com.hm.apache.commons.text.translate.CharSequenceTranslator;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class LookupTranslator
extends CharSequenceTranslator {
    private final Map<String, String> lookupMap;
    private final BitSet prefixSet;
    private final int shortest;
    private final int longest;

    public LookupTranslator(Map<CharSequence, CharSequence> map) {
        if (map == null) {
            throw new InvalidParameterException("lookupMap cannot be null");
        }
        this.lookupMap = new HashMap<String, String>();
        this.prefixSet = new BitSet();
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        for (Map.Entry<CharSequence, CharSequence> entry : map.entrySet()) {
            this.lookupMap.put(entry.getKey().toString(), entry.getValue().toString());
            this.prefixSet.set(entry.getKey().charAt(0));
            int n3 = entry.getKey().length();
            if (n3 < n) {
                n = n3;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        this.shortest = n;
        this.longest = n2;
    }

    @Override
    public int translate(CharSequence charSequence, int n, Writer writer) {
        if (this.prefixSet.get(charSequence.charAt(n))) {
            int n2 = this.longest;
            if (n + this.longest > charSequence.length()) {
                n2 = charSequence.length() - n;
            }
            for (int i = n2; i >= this.shortest; --i) {
                CharSequence charSequence2 = charSequence.subSequence(n, n + i);
                String string = this.lookupMap.get(charSequence2.toString());
                if (string == null) continue;
                writer.write(string);
                return i;
            }
        }
        return 0;
    }
}

